/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error.uri;

import java.util.List;
import java.util.Set;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;

public class ShouldHaveParameter
extends BasicErrorMessageFactory {
    private static final String SHOULD_HAVE_PARAMETER_BUT_WAS_MISSING = "%nExpecting actual:%n  <%s>%nto have parameter:%n  <%s>%nbut was missing";
    private static final String SHOULD_HAVE_PARAMETER_WITHOUT_VALUE_BUT_PARAMETER_WAS_MISSING = "%nExpecting actual:%n  <%s>%nto have parameter:%n  <%s>%nwith no value, but parameter was missing";
    private static final String SHOULD_HAVE_PARAMETER_WITH_VALUE_BUT_PARAMETER_WAS_MISSING = "%nExpecting actual:%n  <%s>%nto have parameter:%n  <%s>%nwith value:%n  <%s>%nbut parameter was missing";
    private static final String SHOULD_HAVE_PARAMETER_WITHOUT_VALUE_BUT_HAD_VALUE = "%nExpecting actual:%n  <%s>%nto have parameter:%n  <%s>%nwith no value, but parameter had value:%n  <%s>";
    private static final String SHOULD_HAVE_PARAMETER_WITHOUT_VALUE_BUT_HAD_VALUES = "%nExpecting actual:%n  <%s>%nto have parameter:%n  <%s>%nwith no value, but parameter had values:%n  <%s>";
    private static final String SHOULD_HAVE_PARAMETER_WITH_VALUE_BUT_HAD_NO_VALUE = "%nExpecting actual:%n  <%s>%nto have parameter:%n  <%s>%nwith value:%n  <%s>%nbut parameter had no value";
    private static final String SHOULD_HAVE_PARAMETER_VALUE_BUT_HAD_WRONG_VALUE = "%nExpecting actual:%n  <%s>%nto have parameter:%n  <%s>%nwith value:%n  <%s>%nbut had value:%n  <%s>";
    private static final String SHOULD_HAVE_PARAMETER_VALUE_BUT_HAD_WRONG_VALUES = "%nExpecting actual:%n  <%s>%nto have parameter:%n  <%s>%nwith value:%n  <%s>%nbut had values:%n  <%s>";
    private static final String SHOULD_HAVE_NO_PARAMETER_BUT_HAD_ONE_WITHOUT_VALUE = "%nExpecting actual:%n  <%s>%nnot to have parameter:%n  <%s>%nbut parameter was present with no value";
    private static final String SHOULD_HAVE_NO_PARAMETER_BUT_HAD_ONE_VALUE = "%nExpecting actual:%n  <%s>%nnot to have parameter:%n  <%s>%nbut parameter was present with value:%n  <%s>";
    private static final String SHOULD_HAVE_NO_PARAMETER_BUT_HAD_MULTIPLE_VALUES = "%nExpecting actual:%n  <%s>%nnot to have parameter:%n  <%s>%nbut parameter was present with values:%n  <%s>";
    private static final String SHOULD_HAVE_NO_PARAMETER_WITHOUT_VALUE_BUT_FOUND_ONE = "%nExpecting actual:%n  <%s>%nnot to have parameter:%n  <%s>%nwith no value, but did";
    private static final String SHOULD_HAVE_NO_PARAMETER_WITH_GIVEN_VALUE_BUT_FOUND_ONE = "%nExpecting actual:%n  <%s>%nnot to have parameter:%n  <%s>%nwith value:%n  <%s>%nbut did";
    private static final String SHOULD_HAVE_NO_PARAMETERS = "%nExpecting actual:%n  <%s>%nnot to have any parameters but found:%n  <%s>";

    public static ErrorMessageFactory shouldHaveParameter(Object actual, String name) {
        return new ShouldHaveParameter(SHOULD_HAVE_PARAMETER_BUT_WAS_MISSING, actual, name);
    }

    public static ErrorMessageFactory shouldHaveParameter(Object actual, String name, String expectedValue) {
        if (expectedValue == null) {
            return new ShouldHaveParameter(SHOULD_HAVE_PARAMETER_WITHOUT_VALUE_BUT_PARAMETER_WAS_MISSING, actual, name);
        }
        return new ShouldHaveParameter(SHOULD_HAVE_PARAMETER_WITH_VALUE_BUT_PARAMETER_WAS_MISSING, actual, name, expectedValue);
    }

    public static ErrorMessageFactory shouldHaveParameter(Object actual, String name, String expectedValue, List<String> actualValues) {
        if (expectedValue == null) {
            return new ShouldHaveParameter(ShouldHaveParameter.multipleValues(actualValues) ? SHOULD_HAVE_PARAMETER_WITHOUT_VALUE_BUT_HAD_VALUES : SHOULD_HAVE_PARAMETER_WITHOUT_VALUE_BUT_HAD_VALUE, actual, name, ShouldHaveParameter.valueDescription(actualValues));
        }
        if (ShouldHaveParameter.noValueIn(actualValues)) {
            return new ShouldHaveParameter(SHOULD_HAVE_PARAMETER_WITH_VALUE_BUT_HAD_NO_VALUE, actual, name, expectedValue);
        }
        return new ShouldHaveParameter(ShouldHaveParameter.multipleValues(actualValues) ? SHOULD_HAVE_PARAMETER_VALUE_BUT_HAD_WRONG_VALUES : SHOULD_HAVE_PARAMETER_VALUE_BUT_HAD_WRONG_VALUE, actual, name, expectedValue, ShouldHaveParameter.valueDescription(actualValues));
    }

    public static ErrorMessageFactory shouldHaveNoParameters(Object actual, Set<String> parameterNames) {
        String parametersDescription = parameterNames.size() == 1 ? parameterNames.iterator().next() : parameterNames.toString();
        return new ShouldHaveParameter(SHOULD_HAVE_NO_PARAMETERS, actual, parametersDescription);
    }

    public static ErrorMessageFactory shouldHaveNoParameter(Object actual, String name, List<String> actualValues) {
        return ShouldHaveParameter.noValueIn(actualValues) ? new ShouldHaveParameter(SHOULD_HAVE_NO_PARAMETER_BUT_HAD_ONE_WITHOUT_VALUE, actual, name) : new ShouldHaveParameter(ShouldHaveParameter.multipleValues(actualValues) ? SHOULD_HAVE_NO_PARAMETER_BUT_HAD_MULTIPLE_VALUES : SHOULD_HAVE_NO_PARAMETER_BUT_HAD_ONE_VALUE, actual, name, ShouldHaveParameter.valueDescription(actualValues));
    }

    public static ErrorMessageFactory shouldHaveNoParameter(Object actual, String name, String unwantedValue, List<String> actualValues) {
        if (ShouldHaveParameter.noValueIn(actualValues)) {
            return new ShouldHaveParameter(SHOULD_HAVE_NO_PARAMETER_WITHOUT_VALUE_BUT_FOUND_ONE, actual, name);
        }
        return new ShouldHaveParameter(SHOULD_HAVE_NO_PARAMETER_WITH_GIVEN_VALUE_BUT_FOUND_ONE, actual, name, unwantedValue);
    }

    private static boolean noValueIn(List<String> actualValues) {
        return actualValues == null || actualValues.size() == 1 && actualValues.contains(null);
    }

    private static String valueDescription(List<String> actualValues) {
        return ShouldHaveParameter.multipleValues(actualValues) ? actualValues.toString() : actualValues.get(0);
    }

    private static boolean multipleValues(List<String> values) {
        return values.size() > 1;
    }

    private ShouldHaveParameter(String format, Object ... arguments) {
        super(format, arguments);
    }
}

