/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.transformers;

import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.component.framework.schedulers.TaskScheduler;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import com.swirlds.component.framework.wires.input.BindableInputWire;
import com.swirlds.component.framework.wires.input.InputWire;
import com.swirlds.component.framework.wires.output.OutputWire;
import com.swirlds.component.framework.wires.output.StandardOutputWire;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;

public class WireListSplitter<T> {
    private final BindableInputWire<List<T>, T> inputWire;
    private final StandardOutputWire<T> outputWire;

    public WireListSplitter(@NonNull WiringModel model, @NonNull String splitterName, @NonNull String splitterInputName) {
        TaskScheduler taskScheduler = model.schedulerBuilder(splitterName).withType(TaskSchedulerType.DIRECT_THREADSAFE).build();
        this.inputWire = taskScheduler.buildInputWire(splitterInputName);
        this.outputWire = (StandardOutputWire)taskScheduler.getOutputWire();
        this.inputWire.bindConsumer(list -> {
            for (Object t : list) {
                this.outputWire.forward((T)t);
            }
        });
    }

    @NonNull
    public InputWire<List<T>> getInputWire() {
        return this.inputWire;
    }

    @NonNull
    public OutputWire<T> getOutputWire() {
        return this.outputWire;
    }
}

