/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract.codec;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.contract.ContractCallTransactionBody;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class ContractCallTransactionBodyJsonCodec
implements JsonCodec<ContractCallTransactionBody> {
    @NonNull
    public ContractCallTransactionBody parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            ContractID temp_contractID = null;
            long temp_gas = 0L;
            long temp_amount = 0L;
            Bytes temp_functionParameters = Bytes.EMPTY;
            block14: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "contractID": {
                        temp_contractID = (ContractID)ContractID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block14;
                    }
                    case "gas": {
                        temp_gas = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block14;
                    }
                    case "amount": {
                        temp_amount = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block14;
                    }
                    case "functionParameters": {
                        temp_functionParameters = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block14;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new ContractCallTransactionBody(temp_contractID, temp_gas, temp_amount, temp_functionParameters);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull ContractCallTransactionBody data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.contractID() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"contractID", ContractID.JSON, (Object)data.contractID()));
        }
        if (data.gas() != 0L) {
            fieldLines.add(JsonTools.field((String)"gas", (long)data.gas()));
        }
        if (data.amount() != 0L) {
            fieldLines.add(JsonTools.field((String)"amount", (long)data.amount()));
        }
        if (data.functionParameters() != Bytes.EMPTY && data.functionParameters() != null && data.functionParameters().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"functionParameters", (Bytes)data.functionParameters()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

