/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.api.internal;

import com.swirlds.base.internal.BaseExecutorFactory;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.extensions.ConfigUtils;
import com.swirlds.logging.api.Level;
import com.swirlds.logging.api.Marker;
import com.swirlds.logging.api.extensions.emergency.EmergencyLogger;
import com.swirlds.logging.api.extensions.emergency.EmergencyLoggerProvider;
import com.swirlds.logging.api.extensions.event.LogEvent;
import com.swirlds.logging.api.extensions.event.LogEventConsumer;
import com.swirlds.logging.api.extensions.event.LogEventFactory;
import com.swirlds.logging.api.extensions.handler.LogHandler;
import com.swirlds.logging.api.extensions.handler.LogHandlerFactory;
import com.swirlds.logging.api.extensions.provider.LogProvider;
import com.swirlds.logging.api.extensions.provider.LogProviderFactory;
import com.swirlds.logging.api.internal.LoggerImpl;
import com.swirlds.logging.api.internal.event.SimpleLogEventFactory;
import com.swirlds.logging.api.internal.level.HandlerLoggingLevelConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

public class LoggingSystem
implements LogEventConsumer {
    private static final int FLUSH_FREQUENCY = 1000;
    private static final String LOGGING_HANDLER_PREFIX = "logging.handler.";
    private static final int LOGGING_HANDLER_PREFIX_LENGTH = "logging.handler.".length();
    private static final String LOGGING_HANDLER_TYPE = "logging.handler.%s.type";
    private static final EmergencyLogger EMERGENCY_LOGGER = EmergencyLoggerProvider.getEmergencyLogger();
    public static final String ROOT_LOGGER_NAME = "";
    private volatile Configuration configuration;
    private final List<LogHandler> handlers;
    private final Map<String, LoggerImpl> loggers;
    private final AtomicReference<HandlerLoggingLevelConfig> levelConfig;
    private final LogEventFactory logEventFactory = new SimpleLogEventFactory();

    public LoggingSystem(@NonNull Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration, "configuration must not be null");
        this.handlers = new CopyOnWriteArrayList<LogHandler>();
        this.loggers = new ConcurrentHashMap<String, LoggerImpl>();
        this.levelConfig = new AtomicReference<HandlerLoggingLevelConfig>(HandlerLoggingLevelConfig.create(configuration, null));
        Runtime.getRuntime().addShutdownHook(new Thread(this::stopAndFinalize));
        BaseExecutorFactory.getInstance().scheduleAtFixedRate(this::flushHandlers, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    private void flushHandlers() {
        this.handlers.forEach(h -> {
            try {
                if (h.isActive()) {
                    h.flush();
                }
            }
            catch (Exception e) {
                EMERGENCY_LOGGER.log(Level.WARN, "Unexpected error flushing " + h.getName(), e);
            }
        });
    }

    public synchronized void update(@NonNull Configuration configuration) {
        Objects.requireNonNull(configuration, "configuration must not be null");
        if (ConfigUtils.haveEqualProperties((Configuration)this.configuration, (Configuration)configuration)) {
            return;
        }
        this.configuration = configuration;
        this.levelConfig.set(HandlerLoggingLevelConfig.create(configuration, null));
        this.handlers.forEach(handler -> handler.update(configuration));
    }

    public void addHandler(@NonNull LogHandler handler) {
        if (handler == null) {
            EMERGENCY_LOGGER.logNPE("handler");
        } else {
            this.handlers.add(handler);
        }
    }

    public void removeHandler(@NonNull LogHandler handler) {
        if (handler == null) {
            EMERGENCY_LOGGER.logNPE("handler");
        } else {
            this.handlers.remove(handler);
        }
    }

    @NonNull
    public LoggerImpl getLogger(@NonNull String name) {
        if (name == null) {
            EMERGENCY_LOGGER.logNPE("name");
            return this.loggers.computeIfAbsent(ROOT_LOGGER_NAME, n -> new LoggerImpl((String)n, this.logEventFactory, this));
        }
        return this.loggers.computeIfAbsent(name.trim(), n -> new LoggerImpl((String)n, this.logEventFactory, this));
    }

    @Override
    public boolean isEnabled(@NonNull String name, @NonNull Level level, @Nullable Marker marker) {
        if (name == null) {
            EMERGENCY_LOGGER.logNPE("name");
            return this.isEnabled(ROOT_LOGGER_NAME, level, marker);
        }
        if (level == null) {
            EMERGENCY_LOGGER.logNPE("level");
            return true;
        }
        for (LogHandler handler : this.handlers) {
            if (!handler.isEnabled(name, level, marker)) continue;
            return true;
        }
        if (marker == null) {
            return this.levelConfig.get().isEnabled(name, level);
        }
        return this.levelConfig.get().isEnabled(name, level, marker);
    }

    @Override
    public void accept(@NonNull LogEvent event) {
        if (event == null) {
            EMERGENCY_LOGGER.logNPE("event");
            return;
        }
        try {
            boolean handled = false;
            for (LogHandler logHandler : this.handlers) {
                if (!logHandler.isEnabled(event.loggerName(), event.level(), event.marker())) continue;
                try {
                    logHandler.handle(event);
                    handled = true;
                }
                catch (Throwable throwable) {
                    EMERGENCY_LOGGER.log(Level.ERROR, "Exception in handling log event by logHandler " + logHandler.getClass().getName(), throwable);
                }
            }
            if (!handled && this.levelConfig.get().isEnabled(event.loggerName(), event.level(), event.marker())) {
                EMERGENCY_LOGGER.log(event);
            }
        }
        catch (Throwable throwable) {
            EMERGENCY_LOGGER.log(Level.ERROR, "Exception in handling log event", throwable);
        }
    }

    public void installProviders() {
        ServiceLoader<LogProviderFactory> serviceLoader = ServiceLoader.load(LogProviderFactory.class);
        List<LogProvider> providers = serviceLoader.stream().map(ServiceLoader.Provider::get).map(factory -> factory.create(this.configuration)).filter(LogProvider::isActive).toList();
        providers.forEach(p -> p.install(this.getLogEventFactory(), this));
        EMERGENCY_LOGGER.log(Level.DEBUG, providers.size() + " logging providers installed: " + String.valueOf(providers));
    }

    public void installHandlers() {
        Map servicesMap = ServiceLoader.load(LogHandlerFactory.class).stream().map(ServiceLoader.Provider::get).collect(Collectors.toUnmodifiableMap(LogHandlerFactory::getTypeName, Function.identity()));
        Set handlerNames = this.configuration.getPropertyNames().filter(property -> property.startsWith(LOGGING_HANDLER_PREFIX)).map(property -> {
            int index = property.indexOf(46, LOGGING_HANDLER_PREFIX_LENGTH);
            return property.substring(LOGGING_HANDLER_PREFIX_LENGTH, index);
        }).collect(Collectors.toUnmodifiableSet());
        List<LogHandler> handlers = handlerNames.stream().map(handlerName -> {
            String handlerType = this.configuration.getValue(LOGGING_HANDLER_TYPE.formatted(handlerName), (String)null);
            if (handlerType != null) {
                LogHandlerFactory handlerFactory = (LogHandlerFactory)servicesMap.get(handlerType);
                if (handlerFactory != null) {
                    return handlerFactory.create((String)handlerName, this.configuration);
                }
                EMERGENCY_LOGGER.log(Level.ERROR, "No handler type '%s' found for logging handler '%s'".formatted(handlerType, handlerName));
                return null;
            }
            EMERGENCY_LOGGER.log(Level.ERROR, "No 'type' attribute for logging handler '%s' found".formatted(handlerName));
            return null;
        }).filter(Objects::nonNull).filter(LogHandler::isActive).toList();
        handlers.forEach(this::addHandler);
        EMERGENCY_LOGGER.log(Level.DEBUG, handlers.size() + " logging handlers installed: " + String.valueOf(handlers));
    }

    public void stopAndFinalize() {
        this.handlers.forEach(LogHandler::stopAndFinalize);
    }

    @NonNull
    public LogEventFactory getLogEventFactory() {
        return this.logEventFactory;
    }

    @NonNull
    public List<LogHandler> getHandlers() {
        return Collections.unmodifiableList(this.handlers);
    }
}

