/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.consistency;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.swirlds.common.config.StateCommonConfig;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.demo.consistency.ConsistencyTestingToolConfig;
import com.swirlds.demo.consistency.ConsistencyTestingToolState;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.system.InitTrigger;
import com.swirlds.platform.system.Platform;
import com.swirlds.platform.test.fixtures.state.TestingAppStateInitializer;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.event.Event;
import org.hiero.consensus.model.hashgraph.Round;
import org.hiero.consensus.model.roster.AddressBook;
import org.hiero.consensus.model.transaction.ScopedSystemTransaction;
import org.hiero.consensus.model.transaction.Transaction;

public class ConsistencyTestingToolConsensusStateEventHandler
implements ConsensusStateEventHandler<ConsistencyTestingToolState> {
    private static final Logger logger = LogManager.getLogger(ConsistencyTestingToolState.class);
    @NonNull
    private final PlatformStateFacade platformStateFacade;
    private Duration freezeAfterGenesis = null;

    public ConsistencyTestingToolConsensusStateEventHandler(@NonNull PlatformStateFacade platformStateFacade) {
        this.platformStateFacade = platformStateFacade;
    }

    public void onStateInitialized(@NonNull ConsistencyTestingToolState state, @NonNull Platform platform, @NonNull InitTrigger trigger, @Nullable SemanticVersion previousVersion) {
        Objects.requireNonNull(platform);
        Objects.requireNonNull(trigger);
        StateCommonConfig stateConfig = (StateCommonConfig)platform.getContext().getConfiguration().getConfigData(StateCommonConfig.class);
        ConsistencyTestingToolConfig testingToolConfig = (ConsistencyTestingToolConfig)platform.getContext().getConfiguration().getConfigData(ConsistencyTestingToolConfig.class);
        Path logFileDirectory = stateConfig.savedStateDirectory().resolve(testingToolConfig.logfileDirectory()).resolve(Long.toString(platform.getSelfId().id()));
        try {
            Files.createDirectories(logFileDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("unable to set up file system for consistency data", e);
        }
        Path logFilePath = logFileDirectory.resolve("ConsistencyTestLog.csv");
        this.freezeAfterGenesis = testingToolConfig.freezeAfterGenesis();
        state.initState(logFilePath);
        TestingAppStateInitializer.DEFAULT.initConsensusModuleStates((MerkleNodeState)state);
    }

    public void onHandleConsensusRound(@NonNull Round round, @NonNull ConsistencyTestingToolState state, @NonNull Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTransactionCallback) {
        Objects.requireNonNull(round);
        Objects.requireNonNull(state);
        if (state.getRoundsHandled() == 0L && !this.freezeAfterGenesis.equals(Duration.ZERO)) {
            logger.info(LogMarker.STARTUP.getMarker(), "Setting freeze time to {} seconds after genesis.", (Object)this.freezeAfterGenesis.getSeconds());
            this.platformStateFacade.bulkUpdateOf((State)state, v -> v.setFreezeTime(round.getConsensusTimestamp().plus(this.freezeAfterGenesis)));
        }
        state.processTransactions(round, stateSignatureTransactionCallback);
    }

    public void onPreHandle(@NonNull Event event, @NonNull ConsistencyTestingToolState state, @NonNull Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTransactionCallback) {
        event.forEachTransaction(transaction -> {
            if (ConsistencyTestingToolState.isSystemTransaction(transaction)) {
                state.consumeSystemTransaction((Transaction)transaction, event, stateSignatureTransactionCallback);
                return;
            }
            state.processPrehandle((Transaction)transaction);
        });
    }

    public boolean onSealConsensusRound(@NonNull Round round, @NonNull ConsistencyTestingToolState state) {
        return true;
    }

    public void onUpdateWeight(@NonNull ConsistencyTestingToolState state, @NonNull AddressBook configAddressBook, @NonNull PlatformContext context) {
    }

    public void onNewRecoveredState(@NonNull ConsistencyTestingToolState recoveredState) {
    }
}

