/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.test.fixtures;

import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableQueueState;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.test.fixtures.MapReadableKVState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MapReadableStates
implements ReadableStates {
    private final Map<Integer, ?> states;

    public MapReadableStates(@NonNull Map<Integer, ?> states) {
        this.states = Objects.requireNonNull(states);
    }

    @NonNull
    public <K, V> ReadableKVState<K, V> get(int stateId) {
        Object state = this.states.get(stateId);
        if (state == null) {
            throw new IllegalArgumentException("Unknown K/V state ID " + stateId);
        }
        return (ReadableKVState)state;
    }

    @NonNull
    public <T> ReadableSingletonState<T> getSingleton(int stateId) {
        Object state = this.states.get(stateId);
        if (state == null) {
            throw new IllegalArgumentException("Unknown singleton state ID " + stateId);
        }
        return (ReadableSingletonState)state;
    }

    @NonNull
    public <E> ReadableQueueState<E> getQueue(int stateId) {
        Object state = this.states.get(stateId);
        if (state == null) {
            throw new IllegalArgumentException("Unknown queue state ID " + stateId);
        }
        return (ReadableQueueState)state;
    }

    public boolean contains(int stateId) {
        return this.states.containsKey(stateId);
    }

    @NonNull
    public Set<Integer> stateIds() {
        return Collections.unmodifiableSet(this.states.keySet());
    }

    public int size() {
        return this.states.size();
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<Integer, Object> states = new HashMap<Integer, Object>();

        Builder() {
        }

        @NonNull
        public Builder state(@NonNull MapReadableKVState state) {
            this.states.put(state.getStateId(), (Object)state);
            return this;
        }

        @NonNull
        public Builder state(@NonNull ReadableSingletonState<?> state) {
            this.states.put(state.getStateId(), state);
            return this;
        }

        @NonNull
        public Builder state(@NonNull ReadableQueueState<?> state) {
            this.states.put(state.getStateId(), state);
            return this;
        }

        @NonNull
        public MapReadableStates build() {
            return new MapReadableStates(new HashMap<Integer, Object>(this.states));
        }
    }
}

