/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.concurrent.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class DefaultThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private final Supplier<String> threadNameFactory;
    private final Runnable onStartup;
    private final Thread.UncaughtExceptionHandler exceptionHandler;

    public DefaultThreadFactory(@NonNull ThreadGroup group, @NonNull Supplier<String> threadNameFactory, @NonNull Thread.UncaughtExceptionHandler exceptionHandler, @Nullable Runnable onStartup) {
        this.group = Objects.requireNonNull(group, "group must not be null");
        this.threadNameFactory = Objects.requireNonNull(threadNameFactory, "name must not be null");
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler, "exceptionHandler must not be null");
        this.onStartup = onStartup;
    }

    @Override
    @NonNull
    public Thread newThread(@NonNull Runnable innerRunnable) {
        Objects.requireNonNull(innerRunnable, "innerRunnable must not be null");
        Runnable runnable = () -> {
            if (this.onStartup != null) {
                this.onStartup.run();
            }
            innerRunnable.run();
        };
        Thread thread = new Thread(this.group, runnable, this.threadNameFactory.get(), 0L);
        thread.setUncaughtExceptionHandler(this.exceptionHandler);
        return thread;
    }

    @NonNull
    public static Supplier<String> createThreadNameFactory(@NonNull String threadNamePrefix) {
        Objects.requireNonNull(threadNamePrefix, "threadNamePrefix must not be null");
        AtomicLong threadNumber = new AtomicLong(1L);
        return () -> threadNamePrefix + "-" + threadNumber.getAndIncrement();
    }
}

