/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.stack.primitive;

import org.eclipse.collections.api.block.function.primitive.DoubleIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoubleIntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.list.primitive.DoubleList;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.stack.primitive.DoubleStack;

public interface MutableDoubleStack
extends DoubleStack {
    public void push(double var1);

    public double pop();

    public DoubleList pop(int var1);

    public void clear();

    @Override
    public MutableDoubleStack select(DoublePredicate var1);

    @Override
    public MutableDoubleStack reject(DoublePredicate var1);

    @Override
    default public MutableDoubleStack tap(DoubleProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    public <V> MutableStack<V> collect(DoubleToObjectFunction<? extends V> var1);

    @Override
    default public MutableDoubleStack selectWithIndex(DoubleIntPredicate predicate) {
        int[] index = new int[]{0};
        return this.select(each -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each, n);
        });
    }

    @Override
    default public MutableDoubleStack rejectWithIndex(DoubleIntPredicate predicate) {
        int[] index = new int[]{0};
        return this.reject(each -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each, n);
        });
    }

    default public <V> MutableStack<V> collectWithIndex(DoubleIntToObjectFunction<? extends V> function) {
        int[] index = new int[]{0};
        return this.collect((double each) -> {
            int n = index[0];
            index[0] = n + 1;
            return function.value(each, n);
        });
    }

    public MutableDoubleStack asUnmodifiable();

    public MutableDoubleStack asSynchronized();

    default public MutableDoubleStack newEmpty() {
        throw new UnsupportedOperationException("Implement in concrete classes.");
    }
}

