/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.virtualmerkle.state;

import com.swirlds.common.config.StateCommonConfig;
import com.swirlds.common.io.config.TemporaryFileConfig;
import com.swirlds.common.utility.AutoCloseableWrapper;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.demo.platform.PlatformTestingToolState;
import com.swirlds.demo.platform.UnsafeMutablePTTStateAccessor;
import com.swirlds.demo.virtualmerkle.config.VirtualMerkleConfig;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkledb.MerkleDbDataSourceBuilder;
import com.swirlds.merkledb.config.MerkleDbConfig;
import com.swirlds.platform.system.Platform;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.config.VirtualMapConfig;
import com.swirlds.virtualmap.datasource.VirtualDataSourceBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;

public final class VirtualMerkleStateInitializer {
    private static final Configuration CONFIGURATION = ConfigurationBuilder.create().withConfigDataType(MerkleDbConfig.class).withConfigDataType(VirtualMapConfig.class).withConfigDataType(TemporaryFileConfig.class).withConfigDataType(StateCommonConfig.class).build();
    private static final MerkleDbConfig MERKLE_DB_CONFIG = (MerkleDbConfig)CONFIGURATION.getConfigData(MerkleDbConfig.class);
    private static final Integer MAX_LIST_CAPACITY = 1000000;
    private static final Logger logger = LogManager.getLogger(VirtualMerkleStateInitializer.class);
    private static final Marker LOGM_DEMO_INFO = LogMarker.DEMO_INFO.getMarker();

    private VirtualMerkleStateInitializer() {
    }

    public static void initStateChildren(Platform platform, long nodeId, VirtualMerkleConfig virtualMerkleConfig) {
        try (AutoCloseableWrapper<PlatformTestingToolState> wrapper = UnsafeMutablePTTStateAccessor.getInstance().getUnsafeMutableState(platform.getSelfId());){
            PlatformTestingToolState state = (PlatformTestingToolState)((Object)wrapper.get());
            logger.info(LOGM_DEMO_INFO, "State = {}", (Object)state);
            long totalAccounts = virtualMerkleConfig.getTotalAccountCreations();
            logger.info(LOGM_DEMO_INFO, "total accounts = {}", (Object)totalAccounts);
            if (state.getVirtualMap() == null && totalAccounts > 0L) {
                logger.info(LOGM_DEMO_INFO, "Creating virtualmap for {} accounts.", (Object)totalAccounts);
                VirtualMap virtualMap = VirtualMerkleStateInitializer.createAccountsVM();
                logger.info(LOGM_DEMO_INFO, "accounts VM = {}, DS = {}", (Object)virtualMap, (Object)virtualMap.getDataSource());
                virtualMap.registerMetrics(platform.getContext().getMetrics());
                state.setVirtualMap(virtualMap);
            }
            long maximumNumberOfKeyValuePairs = virtualMerkleConfig.getMaximumNumberOfKeyValuePairsCreation();
            logger.info(LOGM_DEMO_INFO, "max KV pairs = {}", (Object)maximumNumberOfKeyValuePairs);
            if (state.getVirtualMapForSmartContracts() == null && maximumNumberOfKeyValuePairs > 0L) {
                logger.info(LOGM_DEMO_INFO, "Creating virtualmap for max {} key value pairs.", (Object)maximumNumberOfKeyValuePairs);
                VirtualMap virtualMap = VirtualMerkleStateInitializer.createSmartContractsVM();
                logger.info(LOGM_DEMO_INFO, "SC VM = {}, DS = {}", (Object)virtualMap, (Object)virtualMap.getDataSource());
                virtualMap.registerMetrics(platform.getContext().getMetrics());
                state.setVirtualMapForSmartContracts(virtualMap);
            }
            long totalSmartContracts = virtualMerkleConfig.getTotalSmartContractCreations();
            logger.info(LOGM_DEMO_INFO, "total SC = {}", (Object)totalSmartContracts);
            if (state.getVirtualMapForSmartContractsByteCode() == null && totalSmartContracts > 0L) {
                logger.info(LOGM_DEMO_INFO, "Creating virtualmap for {} bytecodes.", (Object)totalSmartContracts);
                VirtualMap virtualMap = VirtualMerkleStateInitializer.createSmartContractByteCodeVM();
                logger.info(LOGM_DEMO_INFO, "SCBC VM = {}, DS = {}", (Object)virtualMap, (Object)virtualMap.getDataSource());
                virtualMap.registerMetrics(platform.getContext().getMetrics());
                state.setVirtualMapForSmartContractsByteCode(virtualMap);
            }
        }
    }

    private static VirtualMap createAccountsVM() {
        MerkleDbDataSourceBuilder dsBuilder = new MerkleDbDataSourceBuilder(CONFIGURATION, (long)MAX_LIST_CAPACITY.intValue(), MERKLE_DB_CONFIG.hashesRamToDiskThreshold());
        return new VirtualMap("accounts", (VirtualDataSourceBuilder)dsBuilder, CONFIGURATION);
    }

    private static VirtualMap createSmartContractsVM() {
        MerkleDbDataSourceBuilder dsBuilder = new MerkleDbDataSourceBuilder(CONFIGURATION, (long)MAX_LIST_CAPACITY.intValue(), MERKLE_DB_CONFIG.hashesRamToDiskThreshold());
        return new VirtualMap("smartContracts", (VirtualDataSourceBuilder)dsBuilder, CONFIGURATION);
    }

    private static VirtualMap createSmartContractByteCodeVM() {
        MerkleDbDataSourceBuilder dsBuilder = new MerkleDbDataSourceBuilder(CONFIGURATION, (long)MAX_LIST_CAPACITY.intValue(), MERKLE_DB_CONFIG.hashesRamToDiskThreshold());
        return new VirtualMap("smartContractByteCode", (VirtualDataSourceBuilder)dsBuilder, CONFIGURATION);
    }
}

