/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.address;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.config.AddressBookConfig;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.platform.system.address.AddressBookUtils;
import com.swirlds.platform.system.address.AddressBookValidator;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.roster.Address;
import org.hiero.consensus.model.roster.AddressBook;
import org.hiero.consensus.roster.RosterRetriever;
import org.hiero.consensus.roster.RosterUtils;

public class AddressBookInitializer {
    public static final String CONFIG_ADDRESS_BOOK_HEADER = "--- Configuration Address Book ---";
    public static final String STATE_ADDRESS_BOOK_HEADER = "--- State Saved Address Book ---";
    public static final String USED_ADDRESS_BOOK_HEADER = "--- Used Address Book ---";
    public static final String CONFIG_ADDRESS_BOOK_USED = "The Configuration Address Book Was Used.";
    public static final String STATE_ADDRESS_BOOK_USED = "The State Saved Address Book Was Used.";
    public static final String STATE_ADDRESS_BOOK_NULL = "The State Saved Address Book Was NULL.";
    private static final String ADDRESS_BOOK_FILE_PREFIX = "usedAddressBook";
    private static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss").withZone(ZoneId.systemDefault());
    private static final Logger logger = LogManager.getLogger(AddressBookInitializer.class);
    private final NodeId selfId;
    @NonNull
    private final PlatformContext platformContext;
    @NonNull
    private final ConsensusStateEventHandler consensusStateEventHandler;
    private final boolean softwareUpgrade;
    @NonNull
    private final SignedState initialState;
    @Nullable
    private final AddressBook stateAddressBook;
    @NonNull
    private final AddressBook configAddressBook;
    @NonNull
    private final AddressBook currentAddressBook;
    @Nullable
    private final AddressBook previousAddressBook;
    @NonNull
    private final Path pathToAddressBookDirectory;
    private final int maxNumFiles;
    private final boolean useConfigAddressBook;
    private boolean addressBookChange = false;

    public AddressBookInitializer(@NonNull NodeId selfId, boolean softwareUpgrade, @NonNull SignedState initialState, @NonNull AddressBook configAddressBook, @NonNull PlatformContext platformContext, @NonNull ConsensusStateEventHandler consensusStateEventHandler, @NonNull PlatformStateFacade platformStateFacade) {
        this.selfId = Objects.requireNonNull(selfId, "The selfId must not be null.");
        this.softwareUpgrade = softwareUpgrade;
        this.configAddressBook = Objects.requireNonNull(configAddressBook, "The configAddressBook must not be null.");
        this.platformContext = Objects.requireNonNull(platformContext, "The platformContext must not be null.");
        this.consensusStateEventHandler = consensusStateEventHandler;
        AddressBookConfig addressBookConfig = (AddressBookConfig)platformContext.getConfiguration().getConfigData(AddressBookConfig.class);
        this.initialState = Objects.requireNonNull(initialState, "The initialState must not be null.");
        long round = platformStateFacade.roundOf(initialState.getState());
        AddressBook book = RosterUtils.buildAddressBook((Roster)RosterRetriever.retrieveActive((State)initialState.getState(), (long)round));
        AddressBook addressBook = this.stateAddressBook = book == null || book.getSize() == 0 ? null : book;
        if (this.stateAddressBook == null && !initialState.isGenesisState()) {
            throw new IllegalStateException("Only genesis states can have null address books.");
        }
        this.pathToAddressBookDirectory = Path.of(addressBookConfig.addressBookDirectory(), new String[0]);
        try {
            Files.createDirectories(this.pathToAddressBookDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Not able to create directory: {}", (Object)this.pathToAddressBookDirectory, (Object)e);
            throw new IllegalStateException("Not able to create directory: " + String.valueOf(this.pathToAddressBookDirectory), e);
        }
        this.useConfigAddressBook = addressBookConfig.forceUseOfConfigAddressBook();
        this.maxNumFiles = addressBookConfig.maxRecordedAddressBookFiles();
        InitializedAddressBooks addressBooks = this.initialize();
        this.currentAddressBook = addressBooks.currentAddressBook();
        if (!this.useConfigAddressBook && this.stateAddressBook != null) {
            AddressBookValidator.validateNewAddressBook(this.stateAddressBook, this.currentAddressBook);
        }
        this.previousAddressBook = addressBooks.previousAddressBook();
    }

    @NonNull
    public AddressBook getCurrentAddressBook() {
        return this.currentAddressBook;
    }

    @Nullable
    public AddressBook getPreviousAddressBook() {
        return this.previousAddressBook;
    }

    public boolean hasAddressBookChanged() {
        return this.addressBookChange;
    }

    @NonNull
    private InitializedAddressBooks initialize() {
        AddressBook previousAddressBook;
        AddressBook candidateAddressBook;
        if (this.useConfigAddressBook) {
            logger.info(LogMarker.STARTUP.getMarker(), "Overriding the address book in the state with the address book from config.txt");
            candidateAddressBook = this.configAddressBook;
            previousAddressBook = this.stateAddressBook;
            this.addressBookChange = true;
        } else if (this.initialState.isGenesisState()) {
            logger.info(LogMarker.STARTUP.getMarker(), "Starting from genesis: using the config address book.");
            candidateAddressBook = this.configAddressBook;
            this.checkCandidateAddressBookValidity(candidateAddressBook);
            previousAddressBook = null;
            this.addressBookChange = true;
        } else if (!this.softwareUpgrade) {
            logger.info(LogMarker.STARTUP.getMarker(), "Using the loaded state's address book and weight values.");
            candidateAddressBook = this.stateAddressBook;
            previousAddressBook = null;
            this.addressBookChange = false;
        } else {
            logger.info(LogMarker.STARTUP.getMarker(), "The address book weight may be updated by the application using data from the state snapshot.");
            AddressBook configAddressBookCopy = this.configAddressBook.copy();
            this.consensusStateEventHandler.onUpdateWeight(this.initialState.getState(), configAddressBookCopy, this.platformContext);
            candidateAddressBook = configAddressBookCopy;
            candidateAddressBook = this.checkCandidateAddressBookValidity(candidateAddressBook);
            previousAddressBook = this.stateAddressBook;
            this.copyCertsIfAbsent(this.configAddressBook, this.stateAddressBook);
            this.addressBookChange = true;
        }
        this.recordAddressBooks(candidateAddressBook);
        return new InitializedAddressBooks(candidateAddressBook, previousAddressBook);
    }

    private void copyCertsIfAbsent(@NonNull AddressBook configAddressBook, @NonNull AddressBook stateAddressBook) {
        for (Address address : stateAddressBook) {
            if (address.getSigCert() != null || !configAddressBook.contains(address.getNodeId())) continue;
            X509Certificate sigCert = configAddressBook.getAddress(address.getNodeId()).getSigCert();
            X509Certificate agreeCert = configAddressBook.getAddress(address.getNodeId()).getAgreeCert();
            if (sigCert != null) {
                stateAddressBook.add(address.copySetSigCert(sigCert).copySetAgreeCert(agreeCert));
                continue;
            }
            logger.warn("Signing certificate was not found in the config address book for node {}", (Object)address.getNodeId());
        }
    }

    @NonNull
    private AddressBook checkCandidateAddressBookValidity(@Nullable AddressBook candidateAddressBook) {
        if (candidateAddressBook == null) {
            logger.warn(LogMarker.STARTUP.getMarker(), "The candidateAddressBook is null, using configAddressBook instead.");
            return this.configAddressBook;
        }
        if (!AddressBookValidator.hasNonZeroWeight(candidateAddressBook) || !AddressBookValidator.sameExceptForWeight(this.configAddressBook, candidateAddressBook)) {
            if (!AddressBookValidator.hasNonZeroWeight(this.configAddressBook)) {
                throw new IllegalStateException("The candidateAddressBook is not valid and the configAddressBook has 0 total weight.");
            }
            logger.warn(LogMarker.STARTUP.getMarker(), "The candidateAddressBook is not valid, using configAddressBook instead.");
            return this.configAddressBook;
        }
        return candidateAddressBook;
    }

    private synchronized void recordAddressBooks(@NonNull AddressBook usedAddressBook) {
        String date = DATE_TIME_FORMAT.format(Instant.now());
        String addressBookFileName = "%s_v%s_%s_node_%s.txt".formatted(ADDRESS_BOOK_FILE_PREFIX, 1, date, this.selfId);
        String addressBookDebugFileName = addressBookFileName + ".debug";
        try {
            File debugFile = Path.of(this.pathToAddressBookDirectory.toString(), addressBookDebugFileName).toFile();
            try (FileWriter out = new FileWriter(debugFile);){
                out.write("--- Configuration Address Book ---\n");
                out.write(AddressBookUtils.addressBookConfigText(this.configAddressBook) + "\n\n");
                out.write("--- State Saved Address Book ---\n");
                String text = this.stateAddressBook == null ? STATE_ADDRESS_BOOK_NULL : AddressBookUtils.addressBookConfigText(this.stateAddressBook);
                out.write(text + "\n\n");
                out.write("--- Used Address Book ---\n");
                if (usedAddressBook == this.configAddressBook) {
                    out.write(CONFIG_ADDRESS_BOOK_USED);
                } else if (usedAddressBook == this.stateAddressBook) {
                    out.write(STATE_ADDRESS_BOOK_USED);
                } else {
                    out.write(AddressBookUtils.addressBookConfigText(usedAddressBook));
                }
                out.write("\n\n");
            }
            File usedFile = Path.of(this.pathToAddressBookDirectory.toString(), addressBookFileName).toFile();
            try (FileWriter out = new FileWriter(usedFile);){
                out.write(AddressBookUtils.addressBookConfigText(usedAddressBook));
            }
        }
        catch (IOException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Not able to write address book to file. ", (Throwable)e);
        }
        this.cleanAddressBookDirectory();
    }

    private synchronized void cleanAddressBookDirectory() {
        try (Stream<Path> filesStream = Files.list(this.pathToAddressBookDirectory);){
            List<Path> files = filesStream.sorted().toList();
            if (files.size() > this.maxNumFiles) {
                for (int i = 0; i < files.size() - this.maxNumFiles; ++i) {
                    Files.delete(files.get(i));
                }
            }
        }
        catch (IOException e) {
            logger.info(LogMarker.EXCEPTION.getMarker(), "Unable to list files in address book directory. ", (Throwable)e);
        }
    }

    @NonNull
    public Path getPathToAddressBookDirectory() {
        return this.pathToAddressBookDirectory;
    }

    private record InitializedAddressBooks(@NonNull AddressBook currentAddressBook, @Nullable AddressBook previousAddressBook) {
    }
}

