/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.concurrent.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import org.hiero.base.concurrent.ExecutorFactory;
import org.hiero.base.concurrent.internal.DefaultForkJoinWorkerThreadFactory;
import org.hiero.base.concurrent.internal.DefaultThreadFactory;

public class DefaultExecutorFactory
implements ExecutorFactory {
    private final ThreadFactory executorThreadFactory;
    private final ThreadFactory scheduledExecutorThreadFactory;
    private final ThreadFactory singleThreadFactory;
    private final ForkJoinPool.ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory;
    private final Thread.UncaughtExceptionHandler handler;

    public DefaultExecutorFactory(@NonNull ThreadFactory singleThreadFactory, @NonNull ThreadFactory executorThreadFactory, @NonNull ThreadFactory scheduledExecutorThreadFactory, @NonNull ForkJoinPool.ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory, @NonNull Thread.UncaughtExceptionHandler handler) {
        this.singleThreadFactory = Objects.requireNonNull(singleThreadFactory, "singleThreadFactory must not be null");
        this.executorThreadFactory = Objects.requireNonNull(executorThreadFactory, "executorThreadFactory must not be null");
        this.scheduledExecutorThreadFactory = Objects.requireNonNull(scheduledExecutorThreadFactory, "scheduledExecutorThreadFactory must not be null");
        this.forkJoinWorkerThreadFactory = Objects.requireNonNull(forkJoinWorkerThreadFactory, "forkJoinWorkerThreadFactory must not be null");
        this.handler = Objects.requireNonNull(handler, "handler must not be null");
    }

    @Override
    public ForkJoinPool createForkJoinPool(int parallelism) {
        if (parallelism <= 0) {
            throw new IllegalArgumentException("parallelism must be greater than 0");
        }
        return new ForkJoinPool(parallelism, this.forkJoinWorkerThreadFactory, this.handler, true);
    }

    @Override
    public ExecutorService createExecutorService(int threadCount) {
        if (threadCount <= 0) {
            throw new IllegalArgumentException("threadCount must be greater than 0");
        }
        return Executors.newFixedThreadPool(threadCount, this.executorThreadFactory);
    }

    @Override
    public ScheduledExecutorService createScheduledExecutorService(int threadCount) {
        return Executors.newScheduledThreadPool(threadCount, this.scheduledExecutorThreadFactory);
    }

    @Override
    @NonNull
    public Thread createThread(@NonNull Runnable runnable) {
        Objects.requireNonNull(runnable, "runnable must not be null");
        return this.singleThreadFactory.newThread(runnable);
    }

    @NonNull
    public static DefaultExecutorFactory create(@NonNull String groupName, @Nullable Runnable onStartup, @NonNull Thread.UncaughtExceptionHandler exceptionHandler) {
        Objects.requireNonNull(groupName, "groupName must not be null");
        ThreadGroup group = new ThreadGroup(groupName);
        Supplier<String> singleThreadNameFactory = DefaultThreadFactory.createThreadNameFactory("SingleThread");
        DefaultThreadFactory singleThreadFactory = new DefaultThreadFactory(group, singleThreadNameFactory, exceptionHandler, onStartup);
        Supplier<String> executorThreadNameFactory = DefaultThreadFactory.createThreadNameFactory(groupName + "PoolThread");
        DefaultThreadFactory executorThreadFactory = new DefaultThreadFactory(group, executorThreadNameFactory, exceptionHandler, onStartup);
        Supplier<String> scheduledExecutorThreadNameFactory = DefaultThreadFactory.createThreadNameFactory(groupName + "ScheduledPoolThread");
        DefaultThreadFactory scheduledExecutorThreadFactory = new DefaultThreadFactory(group, scheduledExecutorThreadNameFactory, exceptionHandler, onStartup);
        Supplier<String> forkJoinThreadNameFactory = DefaultForkJoinWorkerThreadFactory.createThreadNameFactory(groupName + "ForkJoinThread");
        DefaultForkJoinWorkerThreadFactory forkJoinThreadFactory = new DefaultForkJoinWorkerThreadFactory(group, forkJoinThreadNameFactory, onStartup);
        return new DefaultExecutorFactory(singleThreadFactory, executorThreadFactory, scheduledExecutorThreadFactory, forkJoinThreadFactory, exceptionHandler);
    }
}

