/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state;

import com.swirlds.base.time.Time;
import com.swirlds.common.FastCopyable;
import com.swirlds.common.merkle.crypto.MerkleCryptography;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.state.StateChangeListener;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.LongSupplier;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.Hashable;

public interface State
extends FastCopyable,
Hashable {
    public void init(Time var1, Configuration var2, Metrics var3, MerkleCryptography var4, LongSupplier var5);

    @NonNull
    public ReadableStates getReadableStates(@NonNull String var1);

    @NonNull
    public WritableStates getWritableStates(@NonNull String var1);

    default public void registerCommitListener(@NonNull StateChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    default public void unregisterCommitListener(@NonNull StateChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    default public State copy() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    default public Hash getHash() {
        throw new UnsupportedOperationException();
    }

    default public boolean isHashed() {
        throw new UnsupportedOperationException();
    }

    default public void computeHash() {
        throw new UnsupportedOperationException();
    }

    default public void createSnapshot(@NonNull Path targetPath) {
        throw new UnsupportedOperationException();
    }

    default public State loadSnapshot(@NonNull Path targetPath) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public boolean isStartUpMode() {
        return true;
    }

    default public String getInfoJson() {
        return "";
    }
}

