/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.constructable.internal;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.hiero.base.constructable.ClassConstructorPair;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.constructable.ConstructableRegistryException;
import org.hiero.base.constructable.ConstructorRegistry;
import org.hiero.base.constructable.NoArgsConstructor;
import org.hiero.base.constructable.RuntimeConstructable;
import org.hiero.base.constructable.URLClassLoaderWithLookup;
import org.hiero.base.constructable.internal.ConstructableClasses;
import org.hiero.base.constructable.internal.ConstructableScanner;
import org.hiero.base.constructable.internal.GenericConstructorRegistry;

public class DefaultConstructableRegistry
implements ConstructableRegistry {
    private final Map<Class<?>, GenericConstructorRegistry<?>> allRegistries = new ConcurrentHashMap();

    @Override
    public <T> ConstructorRegistry<T> getRegistry(Class<T> constructorType) {
        return this.allRegistries.get(constructorType);
    }

    @Override
    public NoArgsConstructor getConstructor(long classId) {
        return this.getOrCreate(NoArgsConstructor.class).getConstructor(classId);
    }

    @Override
    public <T extends RuntimeConstructable> T createObject(long classId) {
        NoArgsConstructor c = this.getConstructor(classId);
        if (c == null) {
            return null;
        }
        return (T)c.get();
    }

    @Override
    public void registerConstructables(String packagePrefix, URLClassLoaderWithLookup additionalClassloader) throws ConstructableRegistryException {
        Collection<ConstructableClasses<?>> scanResults = ConstructableScanner.getConstructableClasses(packagePrefix, additionalClassloader);
        for (ConstructableClasses<?> constructableClasses : scanResults) {
            this.getOrCreate(constructableClasses.getConstructorType()).registerConstructables(constructableClasses, additionalClassloader);
        }
    }

    @Override
    public void registerConstructables(String packagePrefix) throws ConstructableRegistryException {
        this.registerConstructables(packagePrefix, null);
    }

    @Override
    public void registerConstructable(ClassConstructorPair pair) throws ConstructableRegistryException {
        this.getOrCreate(NoArgsConstructor.class).registerConstructable(pair.getConstructableClass(), ((Supplier<? extends RuntimeConstructable>)pair.getConstructor())::get);
    }

    @Override
    public void reset() {
        this.allRegistries.clear();
    }

    private <T> GenericConstructorRegistry<T> getOrCreate(Class<T> constructor) {
        return this.allRegistries.computeIfAbsent(constructor, GenericConstructorRegistry::new);
    }
}

