/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.threading;

import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.common.threading.pool.CachedPoolParallelExecutor;
import com.swirlds.common.threading.pool.ParallelExecutionException;
import com.swirlds.common.threading.pool.ParallelExecutor;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.hiero.base.concurrent.ThrowingRunnable;

public class ReplaceSyncPhaseParallelExecutor
implements ParallelExecutor {
    private static final int NUMBER_OF_PHASES = 3;
    private final ParallelExecutor executor;
    private volatile int phase;
    private final int phaseToReplace;
    private final int taskNumToReplace;
    private final ThrowingRunnable replacementTask;

    public ReplaceSyncPhaseParallelExecutor(@NonNull ThreadManager threadManager, int phaseToReplace, int taskNumToReplace, @NonNull ThrowingRunnable replacementTask) {
        this.phaseToReplace = phaseToReplace;
        this.taskNumToReplace = taskNumToReplace;
        this.replacementTask = Objects.requireNonNull(replacementTask);
        this.executor = new CachedPoolParallelExecutor(threadManager, "sync-phase-thread");
        this.phase = 1;
    }

    private void incPhase() {
        this.phase = this.phase % 3 + 1;
    }

    public int getPhase() {
        return this.phase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doParallelWithHandler(Runnable errorHandler, Callable<T> foregroundTask, ThrowingRunnable ... backgroundTasks) throws ParallelExecutionException {
        try {
            if (this.phase == this.phaseToReplace) {
                if (this.taskNumToReplace == 1) {
                    this.executor.doParallelWithHandler(errorHandler, (Callable)this.replacementTask, backgroundTasks);
                    T t = null;
                    return t;
                }
                ThrowingRunnable[] tasksWithReplacement = Arrays.copyOf(backgroundTasks, backgroundTasks.length);
                tasksWithReplacement[this.taskNumToReplace - 2] = this.replacementTask;
                Object object = this.executor.doParallelWithHandler(errorHandler, foregroundTask, new ThrowingRunnable[]{this.replacementTask});
                return (T)object;
            }
            Object object = this.executor.doParallelWithHandler(errorHandler, foregroundTask, backgroundTasks);
            return (T)object;
        }
        finally {
            this.incPhase();
        }
    }

    public boolean isImmutable() {
        return this.executor.isImmutable();
    }

    public void start() {
        this.executor.start();
    }
}

