/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network;

import com.google.common.annotations.VisibleForTesting;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.utility.throttle.RateLimitedLogger;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.gossip.config.GossipConfig;
import com.swirlds.platform.gossip.config.NetworkEndpoint;
import com.swirlds.platform.gossip.sync.SyncInputStream;
import com.swirlds.platform.gossip.sync.SyncOutputStream;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.network.ConnectionManager;
import com.swirlds.platform.network.ConnectionTracker;
import com.swirlds.platform.network.NetworkUtils;
import com.swirlds.platform.network.PeerInfo;
import com.swirlds.platform.network.SocketConfig;
import com.swirlds.platform.network.SocketConnection;
import com.swirlds.platform.network.connection.NotConnectedConnection;
import com.swirlds.platform.network.connectivity.SocketFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import javax.net.ssl.SSLHandshakeException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.concurrent.locks.AutoClosableResourceLock;
import org.hiero.base.concurrent.locks.Locks;
import org.hiero.base.concurrent.locks.locked.LockedResource;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;

public class OutboundConnectionManager
implements ConnectionManager {
    private final PlatformContext platformContext;
    private final NodeId selfId;
    private final ConnectionTracker connectionTracker;
    private final SocketConfig socketConfig;
    private final GossipConfig gossipConfig;
    private final PeerInfo otherPeer;
    private final RateLimitedLogger socketExceptionLogger;
    private Connection currentConn = NotConnectedConnection.getSingleton();
    private final AutoClosableResourceLock<Connection> lock = Locks.createResourceLock((Object)this.currentConn);
    private final SocketFactory socketFactory;
    private static final Logger logger = LogManager.getLogger(OutboundConnectionManager.class);

    public OutboundConnectionManager(@NonNull NodeId selfId, @NonNull PeerInfo otherPeer, @NonNull PlatformContext platformContext, @NonNull ConnectionTracker connectionTracker, @NonNull KeysAndCerts ownKeysAndCerts) {
        this.platformContext = Objects.requireNonNull(platformContext);
        this.selfId = Objects.requireNonNull(selfId);
        this.connectionTracker = Objects.requireNonNull(connectionTracker);
        this.otherPeer = otherPeer;
        this.socketConfig = (SocketConfig)platformContext.getConfiguration().getConfigData(SocketConfig.class);
        this.gossipConfig = (GossipConfig)platformContext.getConfiguration().getConfigData(GossipConfig.class);
        this.socketExceptionLogger = new RateLimitedLogger(logger, platformContext.getTime(), Duration.ofMinutes(1L));
        this.socketFactory = NetworkUtils.createSocketFactory(selfId, Collections.singletonList(otherPeer), ownKeysAndCerts, platformContext.getConfiguration());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Connection waitForConnection() {
        LockedResource resource = this.lock.lock();
        try {
            while (!((Connection)resource.getResource()).connected()) {
                ((Connection)resource.getResource()).disconnect();
                Connection connection = this.createConnection();
                resource.setResource((Object)connection);
                if (connection.connected() || this.socketConfig.waitBetweenConnectionRetries() <= 0) continue;
                try {
                    Thread.sleep(this.socketConfig.waitBetweenConnectionRetries());
                }
                catch (InterruptedException e) {
                    Connection connection2 = NotConnectedConnection.getSingleton();
                    if (resource == null) return connection2;
                    resource.close();
                    return connection2;
                }
            }
            this.currentConn = (Connection)resource.getResource();
            return this.currentConn;
        }
        finally {
            if (resource != null) {
                try {
                    resource.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private Connection createConnection() {
        NetworkEndpoint networkEndpoint = this.gossipConfig.getEndpointOverride(this.otherPeer.nodeId().id()).orElseGet(() -> {
            try {
                return new NetworkEndpoint(this.otherPeer.nodeId().id(), InetAddress.getByName(this.otherPeer.hostname()), this.otherPeer.port());
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("Host '" + this.otherPeer.hostname() + "' not found", e);
            }
        });
        Socket clientSocket = null;
        SyncOutputStream dos = null;
        SyncInputStream dis = null;
        try {
            clientSocket = this.socketFactory.createClientSocket(networkEndpoint.hostname().getHostAddress(), networkEndpoint.port());
            dos = SyncOutputStream.createSyncOutputStream(this.platformContext, clientSocket.getOutputStream(), this.socketConfig.bufferSize());
            dis = SyncInputStream.createSyncInputStream(this.platformContext, clientSocket.getInputStream(), this.socketConfig.bufferSize());
            logger.debug(LogMarker.NETWORK.getMarker(), "`connect` : finished, {} connected to {}", (Object)this.selfId, (Object)this.otherPeer.nodeId());
            return SocketConnection.create(this.selfId, this.otherPeer.nodeId(), this.connectionTracker, true, clientSocket, dis, dos, this.platformContext.getConfiguration());
        }
        catch (SSLHandshakeException e) {
            NetworkUtils.close(new Closeable[]{clientSocket, dis, dos});
            this.socketExceptionLogger.warn(LogMarker.SOCKET_EXCEPTIONS.getMarker(), "{} failed to connect to {} with error: {}", new Object[]{this.selfId, this.otherPeer.nodeId(), NetworkUtils.formatException(e)});
        }
        catch (SocketException | SocketTimeoutException e) {
            NetworkUtils.close(new Closeable[]{clientSocket, dis, dos});
            this.socketExceptionLogger.debug(LogMarker.TCP_CONNECT_EXCEPTIONS.getMarker(), "{} failed to connect to {} with error:", new Object[]{this.selfId, this.otherPeer.nodeId(), e});
        }
        catch (IOException e) {
            NetworkUtils.close(new Closeable[]{clientSocket, dis, dos});
            String formattedException = NetworkUtils.formatException(e);
            this.socketExceptionLogger.warn(LogMarker.SOCKET_EXCEPTIONS.getMarker(), "{} failed to connect to {} {}", new Object[]{this.selfId, this.otherPeer.nodeId(), formattedException});
        }
        catch (RuntimeException e) {
            NetworkUtils.close(new Closeable[]{clientSocket, dis, dos});
            logger.debug(LogMarker.EXCEPTION.getMarker(), "{} failed to connect to {}", (Object)this.selfId, (Object)this.otherPeer.nodeId(), (Object)e);
        }
        return NotConnectedConnection.getSingleton();
    }

    @Override
    @VisibleForTesting
    public Connection getConnection() {
        return this.currentConn;
    }

    @Override
    public void newConnection(Connection connection) {
        throw new UnsupportedOperationException("Does not accept connections");
    }

    @Override
    public boolean isOutbound() {
        return true;
    }
}

