/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network.protocol;

import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.platform.metrics.ReconnectMetrics;
import com.swirlds.platform.network.protocol.Protocol;
import com.swirlds.platform.reconnect.ReconnectPeerProtocol;
import com.swirlds.platform.reconnect.ReconnectSyncHelper;
import com.swirlds.platform.reconnect.ReconnectThrottle;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.signed.ReservedSignedState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.hiero.consensus.gossip.FallenBehindManager;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.status.PlatformStatus;

public class ReconnectProtocol
implements Protocol {
    private final ReconnectThrottle reconnectThrottle;
    private final Supplier<ReservedSignedState> lastCompleteSignedState;
    private final Duration reconnectSocketTimeout;
    private final ReconnectMetrics reconnectMetrics;
    private final ThreadManager threadManager;
    private final FallenBehindManager fallenBehindManager;
    private final PlatformStateFacade platformStateFacade;
    private final Time time;
    private final PlatformContext platformContext;
    private final AtomicReference<PlatformStatus> platformStatus = new AtomicReference<PlatformStatus>(PlatformStatus.STARTING_UP);
    private final ReconnectSyncHelper reconnectSyncHelper;

    public ReconnectProtocol(@NonNull PlatformContext platformContext, @NonNull ThreadManager threadManager, @NonNull ReconnectThrottle reconnectThrottle, @NonNull Supplier<ReservedSignedState> lastCompleteSignedState, @NonNull Duration reconnectSocketTimeout, @NonNull ReconnectMetrics reconnectMetrics, @NonNull ReconnectSyncHelper reconnectSyncHelper, @NonNull FallenBehindManager fallenBehindManager, @NonNull PlatformStateFacade platformStateFacade) {
        this.platformContext = Objects.requireNonNull(platformContext);
        this.threadManager = Objects.requireNonNull(threadManager);
        this.reconnectThrottle = Objects.requireNonNull(reconnectThrottle);
        this.lastCompleteSignedState = Objects.requireNonNull(lastCompleteSignedState);
        this.reconnectSocketTimeout = Objects.requireNonNull(reconnectSocketTimeout);
        this.reconnectMetrics = Objects.requireNonNull(reconnectMetrics);
        this.reconnectSyncHelper = Objects.requireNonNull(reconnectSyncHelper);
        this.fallenBehindManager = Objects.requireNonNull(fallenBehindManager);
        this.platformStateFacade = platformStateFacade;
        this.time = Objects.requireNonNull(platformContext.getTime());
    }

    @Override
    @NonNull
    public ReconnectPeerProtocol createPeerInstance(@NonNull NodeId peerId) {
        return new ReconnectPeerProtocol(this.platformContext, this.threadManager, Objects.requireNonNull(peerId), this.reconnectThrottle, this.lastCompleteSignedState, this.reconnectSocketTimeout, this.reconnectMetrics, this.reconnectSyncHelper, this.fallenBehindManager, this.platformStatus::get, this.time, this.platformStateFacade);
    }

    @Override
    public void updatePlatformStatus(@NonNull PlatformStatus status) {
        this.platformStatus.set(status);
    }
}

