/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.formatting;

import com.swirlds.common.formatting.HorizontalAlignment;
import java.time.Instant;
import java.util.Iterator;
import java.util.LinkedList;

public final class StringFormattingUtils {
    private StringFormattingUtils() {
    }

    public static void addLine(StringBuilder sb, String line) {
        sb.append(line).append(System.lineSeparator());
    }

    public static void formattedList(StringBuilder sb, Iterator<?> iterator) {
        StringFormattingUtils.formattedList(sb, iterator, ", ");
    }

    public static void formattedList(StringBuilder sb, Iterator<?> iterator, String separator) {
        while (iterator.hasNext()) {
            sb.append(iterator.next());
            if (!iterator.hasNext()) continue;
            sb.append(separator);
        }
    }

    public static String formattedList(Iterator<?> iterator) {
        StringBuilder sb = new StringBuilder();
        StringFormattingUtils.formattedList(sb, iterator, ", ");
        return sb.toString();
    }

    public static String formattedList(Iterator<?> iterator, String separator) {
        StringBuilder sb = new StringBuilder();
        StringFormattingUtils.formattedList(sb, iterator, separator);
        return sb.toString();
    }

    public static String repeatedChar(char c, int count) {
        return String.valueOf(c).repeat(Math.max(0, count));
    }

    public static void commaSeparatedNumber(StringBuilder sb, long value) {
        if (value == 0L) {
            sb.append("0");
            return;
        }
        long runningValue = value;
        if (value < 0L) {
            sb.append("-");
            runningValue *= -1L;
        }
        LinkedList<Integer> parts = new LinkedList<Integer>();
        while (runningValue > 0L) {
            parts.add(0, (int)(runningValue % 1000L));
            runningValue /= 1000L;
        }
        for (int index = 0; index < parts.size(); ++index) {
            if (index == 0) {
                sb.append(parts.get(index));
            } else {
                String digits = Integer.toString((Integer)parts.get(index));
                HorizontalAlignment.ALIGNED_RIGHT.pad(sb, digits, '0', 3, false);
            }
            if (index + 1 >= parts.size()) continue;
            sb.append(",");
        }
    }

    public static String commaSeparatedNumber(long value) {
        StringBuilder sb = new StringBuilder();
        StringFormattingUtils.commaSeparatedNumber(sb, value);
        return sb.toString();
    }

    public static void commaSeparatedNumber(StringBuilder sb, double value, int decimalPlaces) {
        if (decimalPlaces < 0) {
            throw new IllegalArgumentException("decimalPlaces must be >= 0");
        }
        long shift = (long)Math.pow(10.0, decimalPlaces);
        double roundedValue = (double)Math.round(value * (double)shift) / (double)shift;
        long wholePart = (long)roundedValue;
        StringFormattingUtils.commaSeparatedNumber(sb, wholePart);
        if (decimalPlaces > 0) {
            sb.append(".");
            double shiftedFraction = Math.abs(value - (double)wholePart) * (double)shift;
            long roundedFraction = Math.round(shiftedFraction);
            HorizontalAlignment.ALIGNED_RIGHT.pad(sb, Long.toString(roundedFraction), '0', decimalPlaces, false);
        }
    }

    public static String commaSeparatedNumber(double value, int decimalPlaces) {
        StringBuilder sb = new StringBuilder();
        StringFormattingUtils.commaSeparatedNumber(sb, value, decimalPlaces);
        return sb.toString();
    }

    public static String sanitizeTimestamp(Instant timestamp) {
        return timestamp.toString().replace(":", "+");
    }

    public static Instant parseSanitizedTimestamp(String timestamp) {
        return Instant.parse(timestamp.replace("+", ":"));
    }
}

