/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.communication;

import com.swirlds.platform.network.Connection;
import com.swirlds.platform.network.NetworkProtocolException;
import com.swirlds.platform.network.protocol.PeerProtocol;
import com.swirlds.platform.network.protocol.ProtocolRunnable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;

public class TestPeerProtocol
implements PeerProtocol {
    private final AtomicInteger timesRan;
    private final AtomicInteger initiateTrue;
    private final AtomicInteger acceptTrue;
    private final AtomicInteger failedCalled;
    private ProtocolRunnable runProtocol = c -> {};
    private boolean shouldInitiate;
    private boolean shouldAccept;
    private boolean acceptOnSimultaneousInitiate;
    private boolean acceptFailed;

    public TestPeerProtocol() {
        this(false, false, false);
    }

    public TestPeerProtocol(boolean shouldInitiate, boolean shouldAccept, boolean acceptOnSimultaneousInitiate) {
        this.shouldInitiate = shouldInitiate;
        this.shouldAccept = shouldAccept;
        this.acceptOnSimultaneousInitiate = acceptOnSimultaneousInitiate;
        this.timesRan = new AtomicInteger(0);
        this.initiateTrue = new AtomicInteger(0);
        this.acceptTrue = new AtomicInteger(0);
        this.failedCalled = new AtomicInteger(0);
    }

    public TestPeerProtocol copy() {
        return new TestPeerProtocol(this.shouldInitiate(), this.shouldAccept(), this.acceptOnSimultaneousInitiate());
    }

    public void reset() {
        this.timesRan.set(0);
        this.initiateTrue.set(0);
        this.acceptTrue.set(0);
        this.failedCalled.set(0);
        this.shouldInitiate = false;
        this.shouldAccept = false;
        this.acceptOnSimultaneousInitiate = false;
    }

    public TestPeerProtocol setShouldInitiate(boolean shouldInitiate) {
        this.shouldInitiate = shouldInitiate;
        return this;
    }

    public void acceptFailed() {
        this.acceptFailed = true;
    }

    public boolean didAcceptFail() {
        return this.acceptFailed;
    }

    public TestPeerProtocol setShouldAccept(boolean shouldAccept) {
        this.shouldAccept = shouldAccept;
        return this;
    }

    public TestPeerProtocol setAcceptOnSimultaneousInitiate(boolean acceptOnSimultaneousInitiate) {
        this.acceptOnSimultaneousInitiate = acceptOnSimultaneousInitiate;
        return this;
    }

    public TestPeerProtocol setRunProtocol(ProtocolRunnable runProtocol) {
        this.runProtocol = runProtocol;
        return this;
    }

    public int getTimesRan() {
        return this.timesRan.get();
    }

    public boolean shouldInitiate() {
        if (this.shouldInitiate) {
            this.initiateTrue.incrementAndGet();
        }
        return this.shouldInitiate;
    }

    public void initiateFailed() {
        this.failedCalled.incrementAndGet();
    }

    public boolean shouldAccept() {
        if (this.shouldAccept) {
            this.acceptTrue.incrementAndGet();
        }
        return this.shouldAccept;
    }

    public boolean acceptOnSimultaneousInitiate() {
        return this.acceptOnSimultaneousInitiate;
    }

    public void runProtocol(Connection connection) throws NetworkProtocolException, IOException, InterruptedException {
        this.timesRan.incrementAndGet();
        this.runProtocol.runProtocol(connection);
    }

    public void assertInitiateContract() {
        Assertions.assertEquals((int)(this.initiateTrue.get() + this.acceptTrue.get()), (int)(this.failedCalled.get() + this.timesRan.get()), (String)"for each call to shouldInitiate() or shouldAccept() that returns true, initiateFailed() or runProtocol() should be called exactly once");
    }
}

