/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.event;

import com.swirlds.platform.test.fixtures.event.DynamicValue;
import java.util.Random;

public class DynamicValueGenerator<T> {
    private final DynamicValue<T> generator;
    private long previousEventIndex;
    private T previousValue;

    public DynamicValueGenerator(DynamicValue<T> generator) {
        this.generator = generator;
        this.previousValue = null;
        this.previousEventIndex = -1L;
    }

    public T get(Random random, long eventIndex) {
        if (this.previousEventIndex == eventIndex) {
            return this.previousValue;
        }
        if (this.previousEventIndex >= eventIndex) {
            this.reset();
        }
        while (this.previousEventIndex < eventIndex - 1L) {
            this.get(random, this.previousEventIndex + 1L);
        }
        T ret = this.generator.get(random, eventIndex, this.previousValue);
        this.previousValue = ret;
        ++this.previousEventIndex;
        return ret;
    }

    public void reset() {
        this.previousValue = null;
        this.previousEventIndex = -1L;
    }

    public DynamicValueGenerator<T> copy() {
        DynamicValueGenerator<T> ret = this.cleanCopy();
        ret.previousValue = this.previousValue;
        return ret;
    }

    public DynamicValueGenerator<T> cleanCopy() {
        return new DynamicValueGenerator<T>(this.generator);
    }
}

