/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.base.state;

import com.swirlds.base.state.MutabilityException;
import edu.umd.cs.findbugs.annotations.NonNull;

public interface Mutable {
    public boolean isImmutable();

    default public boolean isMutable() {
        return !this.isImmutable();
    }

    default public void throwIfImmutable() {
        this.throwIfImmutable("This operation is not permitted on an immutable object.");
    }

    default public void throwIfImmutable(@NonNull String errorMessage) {
        if (this.isImmutable()) {
            throw new MutabilityException(errorMessage);
        }
    }

    default public void throwIfMutable() {
        this.throwIfMutable("This operation is not permitted on a mutable object.");
    }

    default public void throwIfMutable(@NonNull String errorMessage) {
        if (this.isMutable()) {
            throw new MutabilityException(errorMessage);
        }
    }
}

