/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.disk;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.merkle.StateUtils;
import com.swirlds.state.merkle.StateValue;
import com.swirlds.state.merkle.disk.QueueState;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public final class OnDiskQueueHelper<V> {
    private final int stateId;
    @NonNull
    private final Codec<StateValue<QueueState>> queueStateValueCodec;
    @NonNull
    private final Codec<StateValue<V>> stateValueCodec;
    @NonNull
    private final VirtualMap virtualMap;

    public OnDiskQueueHelper(int stateId, @NonNull Codec<V> valueCodec, @NonNull VirtualMap virtualMap) {
        this.stateId = stateId;
        this.queueStateValueCodec = new StateValue.StateValueCodec<QueueState>(8001, QueueState.QueueStateCodec.INSTANCE);
        this.stateValueCodec = new StateValue.StateValueCodec<V>(stateId, Objects.requireNonNull(valueCodec));
        this.virtualMap = Objects.requireNonNull(virtualMap);
    }

    @NonNull
    public Iterator<V> iterateOnDataSource(long head, long tail) {
        return new QueueIterator(head, tail);
    }

    @NonNull
    public V getFromStore(long index) {
        V value;
        Bytes stateKey = StateUtils.getStateKeyForQueue(this.stateId, index);
        StateValue stateValue = (StateValue)this.virtualMap.get(stateKey, this.stateValueCodec);
        V v = value = stateValue != null ? (V)stateValue.value() : null;
        if (value == null) {
            throw new IllegalStateException("Can't find queue element at index " + index + " in the store");
        }
        return value;
    }

    public void addToStore(long tail, V value) {
        Bytes stateKey = StateUtils.getStateKeyForQueue(this.stateId, tail);
        StateValue<V> stateValue = StateUtils.getStateValueForQueue(this.stateId, value);
        this.virtualMap.put(stateKey, stateValue, this.stateValueCodec);
    }

    @Nullable
    public V removeFromStore(long head) {
        Bytes stateKey = StateUtils.getStateKeyForQueue(this.stateId, head);
        StateValue stateValue = (StateValue)this.virtualMap.remove(stateKey, this.stateValueCodec);
        return stateValue != null ? (V)stateValue.value() : null;
    }

    public QueueState getState() {
        Bytes queueStateKey = StateUtils.getStateKeyForSingleton(this.stateId);
        StateValue queueStateValue = (StateValue)this.virtualMap.get(queueStateKey, this.queueStateValueCodec);
        return queueStateValue != null ? (QueueState)queueStateValue.value() : null;
    }

    public void updateState(@NonNull QueueState state) {
        Bytes keyBytes = StateUtils.getStateKeyForSingleton(this.stateId);
        StateValue<QueueState> queueStateValue = StateUtils.getStateValueForQueueState(state);
        this.virtualMap.put(keyBytes, queueStateValue, this.queueStateValueCodec);
    }

    public static boolean isEmpty(@NonNull QueueState state) {
        return state.head() == state.tail();
    }

    private class QueueIterator
    implements Iterator<V> {
        private final long start;
        private final long limit;
        private long current;

        public QueueIterator(long start, long limit) {
            this.start = start;
            this.limit = limit;
            this.reset();
        }

        @Override
        public boolean hasNext() {
            return this.current < this.limit;
        }

        @Override
        public V next() {
            if (this.current == this.limit) {
                throw new NoSuchElementException();
            }
            try {
                return OnDiskQueueHelper.this.getFromStore(this.current++);
            }
            catch (IllegalStateException e) {
                throw new ConcurrentModificationException(e);
            }
        }

        void reset() {
            this.current = this.start;
        }
    }
}

