/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.state;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.pbj.runtime.Codec;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.test.fixtures.merkle.TestSchema;
import com.swirlds.virtualmap.VirtualMap;

public class MerkleTestBase
extends com.swirlds.state.test.fixtures.merkle.MerkleTestBase {
    protected SemanticVersion v1 = SemanticVersion.newBuilder().major(1).build();
    protected StateMetadata<ProtoBytes, ProtoBytes> fruitMetadata;
    protected StateMetadata<ProtoBytes, ProtoBytes> steamMetadata;
    protected StateMetadata<ProtoBytes, ProtoBytes> countryMetadata;

    protected void setupFruitVirtualMap() {
        super.setupFruitVirtualMap();
        this.fruitMetadata = new StateMetadata("First-Service", (Schema)new TestSchema(1), StateDefinition.onDisk((int)3, (String)"FRUIT", (Codec)ProtoBytes.PROTOBUF, (Codec)ProtoBytes.PROTOBUF, (long)100L));
    }

    protected void setupSingletonCountry() {
        super.setupSingletonCountry();
        this.countryMetadata = new StateMetadata("First-Service", (Schema)new TestSchema(1), StateDefinition.singleton((int)11, (String)"COUNTRY", (Codec)ProtoBytes.PROTOBUF));
    }

    protected void setupSteamQueue() {
        super.setupSteamQueue();
        this.steamMetadata = new StateMetadata("First-Service", (Schema)new TestSchema(1), StateDefinition.queue((int)10001, (String)"STEAM", (Codec)ProtoBytes.PROTOBUF));
    }

    protected void addSingletonState(VirtualMap map, StateMetadata<ProtoBytes, ProtoBytes> md, ProtoBytes value) {
        this.addSingletonState(map, md.serviceName(), md.stateDefinition().stateId(), value);
    }

    protected void addKvState(VirtualMap map, StateMetadata<ProtoBytes, ProtoBytes> md, ProtoBytes key, ProtoBytes value) {
        this.addKvState(map, md.serviceName(), md.stateDefinition().stateId(), key, value);
    }
}

