/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.snapshot;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.metrics.RunningAverageMetric;
import com.swirlds.metrics.api.Counter;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;

public class StateSnapshotManagerMetrics {
    private static final RunningAverageMetric.Config WRITE_STATE_TO_DISK_TIME_CONFIG = new RunningAverageMetric.Config("platform", "writeStateToDisk").withDescription("average time it takes to write a SignedState to disk (in milliseconds)").withUnit("ms");
    private final RunningAverageMetric writeStateToDiskTime;
    private static final RunningAverageMetric.Config STATE_TO_DISK_TIME_CONFIG = new RunningAverageMetric.Config("platform", "stateToDisk").withDescription("average time it takes to do perform all actions when writing a SignedState to disk (in milliseconds)").withUnit("ms");
    private final RunningAverageMetric stateToDiskTime;
    private static final Counter.Config TOTAL_NEVER_SIGNED_DISK_STATES_CONFIG = new Counter.Config("platform", "totalNeverSignedDiskStates").withDescription("total number of disk-bound states that did not receive enough signatures in the allowed time").withUnit("count");
    private final Counter totalNeverSignedDiskStates;

    public StateSnapshotManagerMetrics(@NonNull PlatformContext platformContext) {
        Metrics metrics = platformContext.getMetrics();
        this.stateToDiskTime = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)STATE_TO_DISK_TIME_CONFIG);
        this.writeStateToDiskTime = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)WRITE_STATE_TO_DISK_TIME_CONFIG);
        this.totalNeverSignedDiskStates = (Counter)metrics.getOrCreate((MetricConfig)TOTAL_NEVER_SIGNED_DISK_STATES_CONFIG);
    }

    @NonNull
    public RunningAverageMetric getWriteStateToDiskTimeMetric() {
        return this.writeStateToDiskTime;
    }

    @NonNull
    public RunningAverageMetric getStateToDiskTimeMetric() {
        return this.stateToDiskTime;
    }

    @NonNull
    public Counter getTotalUnsignedDiskStatesMetric() {
        return this.totalNeverSignedDiskStates;
    }
}

