/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.virtualmerkle.transaction.handler;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.demo.merkle.map.MapValueData;
import com.swirlds.demo.merkle.map.internal.ExpectedFCMFamily;
import com.swirlds.demo.platform.Triple;
import com.swirlds.demo.platform.fs.stresstest.proto.CreateAccount;
import com.swirlds.demo.platform.fs.stresstest.proto.CreateSmartContract;
import com.swirlds.demo.platform.fs.stresstest.proto.DeleteAccount;
import com.swirlds.demo.platform.fs.stresstest.proto.SmartContractMethodExecution;
import com.swirlds.demo.platform.fs.stresstest.proto.UpdateAccount;
import com.swirlds.demo.platform.fs.stresstest.proto.VirtualMerkleTransaction;
import com.swirlds.demo.virtualmerkle.map.account.AccountVirtualMapKey;
import com.swirlds.demo.virtualmerkle.map.account.AccountVirtualMapValue;
import com.swirlds.demo.virtualmerkle.map.account.AccountVirtualMapValueCodec;
import com.swirlds.demo.virtualmerkle.map.smartcontracts.bytecode.SmartContractByteCodeMapKey;
import com.swirlds.demo.virtualmerkle.map.smartcontracts.bytecode.SmartContractByteCodeMapValue;
import com.swirlds.demo.virtualmerkle.map.smartcontracts.bytecode.SmartContractByteCodeMapValueCodec;
import com.swirlds.demo.virtualmerkle.map.smartcontracts.data.SmartContractMapKey;
import com.swirlds.demo.virtualmerkle.map.smartcontracts.data.SmartContractMapValue;
import com.swirlds.demo.virtualmerkle.map.smartcontracts.data.SmartContractMapValueCodec;
import com.swirlds.demo.virtualmerkle.random.PTTRandom;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkle.test.fixtures.map.lifecycle.EntityType;
import com.swirlds.merkle.test.fixtures.map.lifecycle.TransactionState;
import com.swirlds.merkle.test.fixtures.map.lifecycle.TransactionType;
import com.swirlds.merkle.test.fixtures.map.pta.MapKey;
import com.swirlds.virtualmap.VirtualMap;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;

public class VirtualMerkleTransactionHandler {
    private static final Logger logger = LogManager.getLogger(VirtualMerkleTransactionHandler.class);
    private static final Marker LOGM_DEMO_INFO = LogMarker.DEMO_INFO.getMarker();

    public static void handle(Instant consensusTimestamp, VirtualMerkleTransaction virtualMerkleTransaction, ExpectedFCMFamily expectedFCMFamily, VirtualMap accountVirtualMap, VirtualMap smartContractVirtualMap, VirtualMap smartContractByteCodeVirtualMap) {
        Triple<Object, Object, MapValueData> expectedMapInfo = virtualMerkleTransaction.hasCreateAccount() ? VirtualMerkleTransactionHandler.handleCreateAccountTransaction(virtualMerkleTransaction.getCreateAccount(), accountVirtualMap) : (virtualMerkleTransaction.hasDeleteAccount() ? VirtualMerkleTransactionHandler.handleDeleteAccountTransaction(virtualMerkleTransaction.getDeleteAccount(), accountVirtualMap) : (virtualMerkleTransaction.hasUpdateAccount() ? VirtualMerkleTransactionHandler.handleUpdateAccountTransaction(virtualMerkleTransaction.getUpdateAccount(), accountVirtualMap) : null));
        if (expectedMapInfo != null) {
            VirtualMerkleTransactionHandler.saveExpectedMapInfo(consensusTimestamp, virtualMerkleTransaction, expectedFCMFamily, expectedMapInfo.left(), expectedMapInfo.middle(), expectedMapInfo.right());
            return;
        }
        if (virtualMerkleTransaction.hasSmartContract()) {
            VirtualMerkleTransactionHandler.handleCreateSmartContractTransaction(virtualMerkleTransaction.getSmartContract(), smartContractVirtualMap, smartContractByteCodeVirtualMap);
        } else if (virtualMerkleTransaction.hasMethodExecution()) {
            VirtualMerkleTransactionHandler.handleMethodExecutionTransaction(virtualMerkleTransaction.getMethodExecution(), smartContractVirtualMap, smartContractByteCodeVirtualMap);
        }
    }

    private static void saveExpectedMapInfo(Instant consensusTimestamp, VirtualMerkleTransaction virtualMerkleTransaction, ExpectedFCMFamily expectedFCMFamily, TransactionType transactionType, MapKey key, MapValueData value) {
        if (virtualMerkleTransaction.getSampled()) {
            expectedFCMFamily.setLatestHandledStatusForKey(key, EntityType.VIRTUAL_MERKLE_ACCOUNT, value, TransactionState.HANDLED, transactionType, consensusTimestamp.getEpochSecond(), virtualMerkleTransaction.getOriginNode(), false);
        }
    }

    private static void handleMethodExecutionTransaction(SmartContractMethodExecution methodExecution, VirtualMap smartContractVirtualMap, VirtualMap smartContractByteCodeVirtualMap) {
        SmartContractMapValue smartContractMapValue;
        Bytes smartContractMapKey;
        long keyValuePairIdx;
        Bytes byteCodeKey = new SmartContractByteCodeMapKey(methodExecution.getContractId()).toBytes();
        SmartContractByteCodeMapValue smartContractByteCodeMapValue = (SmartContractByteCodeMapValue)smartContractByteCodeVirtualMap.get(byteCodeKey, (Codec)SmartContractByteCodeMapValueCodec.INSTANCE);
        if (smartContractByteCodeMapValue == null) {
            logger.warn(LogMarker.DEMO_INFO.getMarker(), "Value for key {} was not found inside smart contract bytecode map.", (Object)byteCodeKey);
            return;
        }
        Bytes contractKey = new SmartContractMapKey(methodExecution.getContractId(), 0L).toBytes();
        SmartContractMapValue smartContractKeyValuePairsCounter = (SmartContractMapValue)smartContractVirtualMap.get(contractKey, (Codec)SmartContractMapValueCodec.INSTANCE);
        if (smartContractKeyValuePairsCounter == null) {
            logger.warn(LogMarker.DEMO_INFO.getMarker(), "Value for key {} was not found inside smart contract map.", (Object)contractKey);
            return;
        }
        long totalKeyValuePairs = smartContractKeyValuePairsCounter.getValueAsLong();
        PTTRandom pttRandom = new PTTRandom(methodExecution.getSeed());
        int i = 0;
        while ((long)i < methodExecution.getReads()) {
            keyValuePairIdx = pttRandom.nextLong(1L, totalKeyValuePairs + 1L);
            smartContractMapKey = new SmartContractMapKey(methodExecution.getContractId(), keyValuePairIdx).toBytes();
            smartContractMapValue = (SmartContractMapValue)smartContractVirtualMap.get(smartContractMapKey, (Codec)SmartContractMapValueCodec.INSTANCE);
            if (smartContractMapValue == null) {
                logger.warn(LogMarker.DEMO_INFO.getMarker(), "Value for key {} was not found inside smart contract map.", (Object)smartContractMapKey);
                return;
            }
            ++i;
        }
        i = 0;
        while ((long)i < methodExecution.getWrites()) {
            keyValuePairIdx = pttRandom.nextLong(1L, totalKeyValuePairs + 1L);
            smartContractMapKey = new SmartContractMapKey(methodExecution.getContractId(), keyValuePairIdx).toBytes();
            smartContractMapValue = (SmartContractMapValue)smartContractVirtualMap.get(smartContractMapKey, (Codec)SmartContractMapValueCodec.INSTANCE);
            if (smartContractMapValue == null) {
                logger.warn(LogMarker.DEMO_INFO.getMarker(), "Value for key {} was not found inside smart contract map.", (Object)smartContractMapKey);
                return;
            }
            SmartContractMapValue mutableSmartContractMapValue = smartContractMapValue.copy();
            mutableSmartContractMapValue.changeValue(pttRandom);
            smartContractVirtualMap.put(smartContractMapKey, (Object)mutableSmartContractMapValue, (Codec)SmartContractMapValueCodec.INSTANCE);
            ++i;
        }
        for (long i2 = totalKeyValuePairs + 1L; i2 <= totalKeyValuePairs + methodExecution.getAdds(); ++i2) {
            Bytes smartContractMapKey2 = new SmartContractMapKey(methodExecution.getContractId(), i2).toBytes();
            smartContractVirtualMap.put(smartContractMapKey2, (Object)new SmartContractMapValue(pttRandom), (Codec)SmartContractMapValueCodec.INSTANCE);
        }
        if (!smartContractVirtualMap.containsKey(contractKey)) {
            throw new IllegalStateException("Contract not found for key=" + String.valueOf(contractKey));
        }
        smartContractVirtualMap.put(contractKey, (Object)new SmartContractMapValue(totalKeyValuePairs + methodExecution.getAdds()), (Codec)SmartContractMapValueCodec.INSTANCE);
    }

    private static void handleCreateSmartContractTransaction(CreateSmartContract smartContract, VirtualMap smartContractVirtualMap, VirtualMap smartContractByteCodeVirtualMap) {
        PTTRandom random = new PTTRandom(smartContract.getSeed());
        int i = 1;
        while ((long)i <= smartContract.getTotalValuePairs()) {
            smartContractVirtualMap.put(new SmartContractMapKey(smartContract.getContractId(), i).toBytes(), (Object)new SmartContractMapValue(random), (Codec)SmartContractMapValueCodec.INSTANCE);
            ++i;
        }
        smartContractVirtualMap.put(new SmartContractMapKey(smartContract.getContractId(), 0L).toBytes(), (Object)new SmartContractMapValue(smartContract.getTotalValuePairs()), (Codec)SmartContractMapValueCodec.INSTANCE);
        SmartContractByteCodeMapKey byteCodeKey = new SmartContractByteCodeMapKey(smartContract.getContractId());
        SmartContractByteCodeMapValue byteCodeValue = new SmartContractByteCodeMapValue(random, smartContract.getByteCodeSize());
        smartContractByteCodeVirtualMap.put(byteCodeKey.toBytes(), (Object)byteCodeValue, (Codec)SmartContractByteCodeMapValueCodec.INSTANCE);
    }

    private static Triple<TransactionType, MapKey, MapValueData> handleUpdateAccountTransaction(UpdateAccount updateAccount, VirtualMap accountVirtualMap) {
        TransactionType transactionType;
        MapValueData value;
        AccountVirtualMapKey accountVirtualMapKey = new AccountVirtualMapKey(updateAccount.getRealmID(), updateAccount.getShardID(), updateAccount.getAccountID());
        Bytes accountVirtualMapKeyBytes = accountVirtualMapKey.toBytes();
        if (accountVirtualMap.containsKey(accountVirtualMapKeyBytes)) {
            AccountVirtualMapValue currentValue = (AccountVirtualMapValue)accountVirtualMap.get(accountVirtualMapKeyBytes, (Codec)AccountVirtualMapValueCodec.INSTANCE);
            AccountVirtualMapValue newValue = new AccountVirtualMapValue(updateAccount.getBalance(), updateAccount.getSendThreshold(), updateAccount.getReceiveThreshold(), updateAccount.getRequireSignature(), currentValue.getUid());
            accountVirtualMap.put(accountVirtualMapKeyBytes, (Object)newValue, (Codec)AccountVirtualMapValueCodec.INSTANCE);
            value = new MapValueData(newValue.getBalance(), newValue.getSendThreshold(), newValue.getReceiveThreshold(), newValue.isRequireSignature(), newValue.getUid());
            transactionType = TransactionType.Update;
        } else {
            value = new MapValueData(updateAccount.getBalance(), updateAccount.getSendThreshold(), updateAccount.getReceiveThreshold(), updateAccount.getRequireSignature(), -1L);
            transactionType = TransactionType.UpdateNotExistentAccount;
        }
        MapKey key = new MapKey(updateAccount.getShardID(), updateAccount.getRealmID(), updateAccount.getAccountID());
        value.setKey(key);
        return Triple.of(transactionType, key, value);
    }

    private static Triple<TransactionType, MapKey, MapValueData> handleDeleteAccountTransaction(DeleteAccount deleteAccount, VirtualMap accountVirtualMap) {
        AccountVirtualMapKey accountVirtualMapKey = new AccountVirtualMapKey(deleteAccount.getRealmID(), deleteAccount.getShardID(), deleteAccount.getAccountID());
        AccountVirtualMapValue removedValue = (AccountVirtualMapValue)accountVirtualMap.remove(accountVirtualMapKey.toBytes(), (Codec)AccountVirtualMapValueCodec.INSTANCE);
        MapKey key = new MapKey(deleteAccount.getShardID(), deleteAccount.getRealmID(), deleteAccount.getAccountID());
        TransactionType transactionType = removedValue == null ? TransactionType.DeleteNotExistentAccount : TransactionType.Delete;
        return Triple.of(transactionType, key, null);
    }

    private static Triple<TransactionType, MapKey, MapValueData> handleCreateAccountTransaction(CreateAccount createAccount, VirtualMap accountVirtualMap) {
        AccountVirtualMapKey accountVirtualMapKey = new AccountVirtualMapKey(createAccount.getRealmID(), createAccount.getShardID(), createAccount.getAccountID());
        AccountVirtualMapValue accountVirtualMapValue = new AccountVirtualMapValue(createAccount.getBalance(), createAccount.getSendThreshold(), createAccount.getReceiveThreshold(), createAccount.getRequireSignature(), createAccount.getUid());
        Bytes accountVirtualMapKeyBytes = accountVirtualMapKey.toBytes();
        TransactionType transactionType = accountVirtualMap.containsKey(accountVirtualMapKeyBytes) ? TransactionType.CreateExistingAccount : TransactionType.Create;
        accountVirtualMap.put(accountVirtualMapKeyBytes, (Object)accountVirtualMapValue, (Codec)AccountVirtualMapValueCodec.INSTANCE);
        MapKey key = new MapKey(createAccount.getShardID(), createAccount.getRealmID(), createAccount.getAccountID());
        MapValueData value = new MapValueData(createAccount.getBalance(), createAccount.getSendThreshold(), createAccount.getReceiveThreshold(), createAccount.getRequireSignature(), createAccount.getUid());
        value.setKey(key);
        return Triple.of(transactionType, key, value);
    }

    public static void handleExpectedMapValidation(ExpectedFCMFamily expectedFCMFamily, VirtualMap virtualMap) {
        if (virtualMap == null) {
            return;
        }
        AtomicBoolean notMismatching = new AtomicBoolean(true);
        expectedFCMFamily.getExpectedMap().forEach((mapKey, expectedValue) -> {
            if (expectedValue.getEntityType() != EntityType.VIRTUAL_MERKLE_ACCOUNT) {
                return;
            }
            AccountVirtualMapKey accountVirtualMapKey = new AccountVirtualMapKey(mapKey.getRealmId(), mapKey.getShardId(), mapKey.getAccountId());
            Bytes accountVirtualMapKeyBytes = accountVirtualMapKey.toBytes();
            TransactionType lastTransactionType = expectedValue.getLatestHandledStatus().getTransactionType();
            if (lastTransactionType == TransactionType.Create || lastTransactionType == TransactionType.Update) {
                AccountVirtualMapValue virtualMapValue = (AccountVirtualMapValue)virtualMap.get(accountVirtualMapKeyBytes, (Codec)AccountVirtualMapValueCodec.INSTANCE);
                if (virtualMapValue == null) {
                    notMismatching.set(false);
                    logger.warn(LogMarker.DEMO_INFO.getMarker(), "An account from the expected map is not present inside the state.");
                    return;
                }
                MapValueData mapValueData = new MapValueData(virtualMapValue.getBalance(), virtualMapValue.getSendThreshold(), virtualMapValue.getReceiveThreshold(), virtualMapValue.isRequireSignature(), virtualMapValue.getUid());
                if (!mapValueData.calculateHash().equals((Object)expectedValue.getHash())) {
                    notMismatching.set(false);
                }
            } else if (lastTransactionType == TransactionType.CreateExistingAccount) {
                if (!virtualMap.containsKey(accountVirtualMapKeyBytes)) {
                    notMismatching.set(false);
                    logger.warn(LogMarker.DEMO_INFO.getMarker(), "A created account does not exist inside the state.");
                }
            } else if ((lastTransactionType == TransactionType.Delete || lastTransactionType == TransactionType.DeleteNotExistentAccount || lastTransactionType == TransactionType.UpdateNotExistentAccount) && virtualMap.containsKey(accountVirtualMapKeyBytes)) {
                notMismatching.set(false);
                logger.warn(LogMarker.DEMO_INFO.getMarker(), "A deleted account is still present inside the state.");
            }
        });
        if (notMismatching.get()) {
            logger.info(LOGM_DEMO_INFO, "There was no mismatch between the expected map and state.");
        }
    }
}

