/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.snapshot;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.common.formatting.StringFormattingUtils;
import com.swirlds.common.formatting.TextTable;
import com.swirlds.common.utility.Mnemonics;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.platform.state.snapshot.SavedStateMetadataField;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Hash;
import org.hiero.base.utility.CommonUtils;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterRetriever;
import org.hiero.consensus.roster.RosterUtils;

public record SavedStateMetadata(long round, @NonNull Hash hash, @NonNull String hashMnemonic, long numberOfConsensusEvents, @NonNull Instant consensusTimestamp, @Nullable Hash legacyRunningEventHash, @Nullable String legacyRunningEventHashMnemonic, long minimumBirthRoundNonAncient, @NonNull String softwareVersion, @NonNull Instant wallClockTime, @NonNull NodeId nodeId, @NonNull List<NodeId> signingNodes, long signingWeightSum, long totalWeight, @Nullable Boolean freezeState) {
    public static final String FILE_NAME = "stateMetadata.txt";
    public static final NodeId NO_NODE_ID = NodeId.of((long)Long.MAX_VALUE);
    private static final Logger logger = LogManager.getLogger(SavedStateMetadata.class);

    public static SavedStateMetadata parse(Path metadataFile) throws IOException {
        Map<SavedStateMetadataField, String> data = SavedStateMetadata.parseStringMap(metadataFile);
        return new SavedStateMetadata(SavedStateMetadata.parsePrimitiveLong(data, SavedStateMetadataField.ROUND), SavedStateMetadata.parseNonNullHash(data, SavedStateMetadataField.HASH), SavedStateMetadata.parseNonNullString(data, SavedStateMetadataField.HASH_MNEMONIC), SavedStateMetadata.parsePrimitiveLong(data, SavedStateMetadataField.NUMBER_OF_CONSENSUS_EVENTS), SavedStateMetadata.parseNonNullInstant(data, SavedStateMetadataField.CONSENSUS_TIMESTAMP), SavedStateMetadata.parseHash(data, SavedStateMetadataField.LEGACY_RUNNING_EVENT_HASH), SavedStateMetadata.parseString(data, SavedStateMetadataField.LEGACY_RUNNING_EVENT_HASH_MNEMONIC), SavedStateMetadata.parsePrimitiveLong(data, SavedStateMetadataField.MINIMUM_BIRTH_ROUND_NON_ANCIENT), SavedStateMetadata.parseNonNullString(data, SavedStateMetadataField.SOFTWARE_VERSION), SavedStateMetadata.parseNonNullInstant(data, SavedStateMetadataField.WALL_CLOCK_TIME), NodeId.of((long)SavedStateMetadata.parsePrimitiveLong(data, SavedStateMetadataField.NODE_ID)), SavedStateMetadata.parseNodeIdList(data, SavedStateMetadataField.SIGNING_NODES), SavedStateMetadata.parsePrimitiveLong(data, SavedStateMetadataField.SIGNING_WEIGHT_SUM), SavedStateMetadata.parsePrimitiveLong(data, SavedStateMetadataField.TOTAL_WEIGHT), SavedStateMetadata.parseNullableBoolean(data, SavedStateMetadataField.FREEZE_STATE));
    }

    private static Boolean parseNullableBoolean(@NonNull Map<SavedStateMetadataField, String> data, @NonNull SavedStateMetadataField field) {
        if (data.containsKey((Object)field)) {
            if ("null".equalsIgnoreCase(data.get((Object)field))) {
                return null;
            }
            return Boolean.parseBoolean(data.get((Object)field));
        }
        SavedStateMetadata.logMissingField(field);
        return null;
    }

    public static SavedStateMetadata create(@NonNull SignedState signedState, @NonNull NodeId selfId, @NonNull Instant now, @NonNull PlatformStateFacade platformStateFacade) {
        Objects.requireNonNull(signedState, "signedState must not be null");
        MerkleNodeState state = signedState.getState();
        Objects.requireNonNull(state.getHash(), "state must be hashed");
        Objects.requireNonNull(now, "now must not be null");
        long round = platformStateFacade.roundOf(state);
        Roster roster = RosterRetriever.retrieveActive((State)state, (long)round);
        List<NodeId> signingNodes = signedState.getSigSet().getSigningNodes();
        Collections.sort(signingNodes);
        return new SavedStateMetadata(signedState.getRound(), state.getHash(), Mnemonics.generateMnemonic((Hash)state.getHash()), platformStateFacade.consensusSnapshotOf(state).nextConsensusNumber(), signedState.getConsensusTimestamp(), platformStateFacade.legacyRunningEventHashOf(state), Mnemonics.generateMnemonic((Hash)platformStateFacade.legacyRunningEventHashOf(state)), platformStateFacade.ancientThresholdOf(state), SavedStateMetadata.convertToString(platformStateFacade.creationSoftwareVersionOf(state)), now, selfId, signingNodes, signedState.getSigningWeight(), roster == null ? 0L : RosterUtils.computeTotalWeight((Roster)roster), signedState.isFreezeState());
    }

    @NonNull
    private static String convertToString(@Nullable Object value) {
        String string;
        String string2 = string = value == null ? "null" : value.toString();
        if (string.contains("\n")) {
            throw new IllegalArgumentException("Value cannot contain newlines: " + String.valueOf(value));
        }
        return string;
    }

    @NonNull
    private static Map<SavedStateMetadataField, String> parseStringMap(@NonNull Path metadataFile) {
        if (!Files.exists(metadataFile, new LinkOption[0])) {
            logger.warn(LogMarker.STARTUP.getMarker(), "Signed state does not have a metadata file at {}", (Object)metadataFile);
            return new EnumMap<SavedStateMetadataField, String>(SavedStateMetadataField.class);
        }
        try {
            EnumMap<SavedStateMetadataField, String> map;
            block13: {
                map = new EnumMap<SavedStateMetadataField, String>(SavedStateMetadataField.class);
                BufferedReader reader = new BufferedReader(new FileReader(metadataFile.toFile()));
                block9: while (true) {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        int colonIndex = line.indexOf(":");
                        if (colonIndex == -1) {
                            logger.warn(LogMarker.STARTUP.getMarker(), "Invalid line in metadata file: {}", (Object)line);
                            continue;
                        }
                        String keyString = line.substring(0, colonIndex).strip();
                        String valueString = line.substring(colonIndex + 1).strip();
                        try {
                            SavedStateMetadataField key = SavedStateMetadataField.valueOf(keyString);
                            map.put(key, valueString);
                            continue block9;
                        }
                        catch (IllegalArgumentException e) {
                            logger.warn(LogMarker.STARTUP.getMarker(), "Unrecognized key in metadata file: {}", (Object)keyString);
                        }
                    }
                    break block13;
                    {
                        continue block9;
                        break;
                    }
                    break;
                }
                finally {
                    reader.close();
                }
            }
            return map;
        }
        catch (IOException e) {
            logger.warn(LogMarker.STARTUP.getMarker(), "Failed to parse signed state metadata file: {}", (Object)metadataFile, (Object)e);
            return new EnumMap<SavedStateMetadataField, String>(SavedStateMetadataField.class);
        }
    }

    private static void logMissingField(@NonNull SavedStateMetadataField field) {
        logger.warn(LogMarker.STARTUP.getMarker(), "Signed state metadata file is missing field: {}", (Object)field);
    }

    private static void logInvalidField(@NonNull SavedStateMetadataField field, @NonNull String value, @NonNull Exception e) {
        logger.warn(LogMarker.STARTUP.getMarker(), "Signed state metadata file has invalid value for field {}: {}", (Object)field, (Object)value, (Object)e);
    }

    private static void throwMissingRequiredField(@NonNull SavedStateMetadataField field) throws IOException {
        Objects.requireNonNull(field);
        throw new IOException("Signed state metadata file is missing required field: " + String.valueOf((Object)field));
    }

    private static void throwInvalidRequiredField(@NonNull SavedStateMetadataField field, @NonNull String value, @NonNull Exception e) throws IOException {
        Objects.requireNonNull(field);
        Objects.requireNonNull(value);
        Objects.requireNonNull(e);
        throw new IOException("Signed state metadata file has an invalid value for required field %s: %s ".formatted(new Object[]{field, value}), e);
    }

    @Nullable
    private static Long parseLong(Map<SavedStateMetadataField, String> data, SavedStateMetadataField field) {
        if (!data.containsKey((Object)field)) {
            SavedStateMetadata.logMissingField(field);
            return null;
        }
        String value = data.get((Object)field);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            SavedStateMetadata.logInvalidField(field, value, e);
            return null;
        }
    }

    private static long parsePrimitiveLong(@NonNull Map<SavedStateMetadataField, String> data, @NonNull SavedStateMetadataField field) throws IOException {
        Objects.requireNonNull(field);
        if (!data.containsKey((Object)field)) {
            SavedStateMetadata.throwMissingRequiredField(field);
            return Long.MIN_VALUE;
        }
        String value = data.get((Object)field);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            SavedStateMetadata.throwInvalidRequiredField(field, value, e);
            return Long.MIN_VALUE;
        }
    }

    @Nullable
    private static String parseString(Map<SavedStateMetadataField, String> data, SavedStateMetadataField field) {
        if (!data.containsKey((Object)field)) {
            SavedStateMetadata.logMissingField(field);
            return null;
        }
        return data.get((Object)field);
    }

    @NonNull
    private static String parseNonNullString(@NonNull Map<SavedStateMetadataField, String> data, @NonNull SavedStateMetadataField field) throws IOException {
        Objects.requireNonNull(field);
        if (!data.containsKey((Object)field)) {
            SavedStateMetadata.throwMissingRequiredField(field);
            return "we will never reach this point";
        }
        return data.get((Object)field);
    }

    @Nullable
    private static Instant parseInstant(Map<SavedStateMetadataField, String> data, SavedStateMetadataField field) {
        if (!data.containsKey((Object)field)) {
            SavedStateMetadata.logMissingField(field);
            return null;
        }
        String value = data.get((Object)field);
        try {
            return Instant.parse(value);
        }
        catch (DateTimeParseException e) {
            SavedStateMetadata.logInvalidField(field, value, e);
            return null;
        }
    }

    @NonNull
    private static Instant parseNonNullInstant(@NonNull Map<SavedStateMetadataField, String> data, @NonNull SavedStateMetadataField field) throws IOException {
        Objects.requireNonNull(field);
        if (!data.containsKey((Object)field)) {
            SavedStateMetadata.throwMissingRequiredField(field);
            return Instant.MIN;
        }
        String value = data.get((Object)field);
        try {
            return Instant.parse(value);
        }
        catch (DateTimeParseException e) {
            SavedStateMetadata.throwInvalidRequiredField(field, value, e);
            return Instant.MIN;
        }
    }

    @NonNull
    private static List<NodeId> parseNodeIdList(@NonNull Map<SavedStateMetadataField, String> data, @NonNull SavedStateMetadataField field) throws IOException {
        if (!data.containsKey((Object)field)) {
            SavedStateMetadata.throwMissingRequiredField(field);
            return null;
        }
        String value = data.get((Object)field);
        String[] parts = value.split(",");
        ArrayList<NodeId> list = new ArrayList<NodeId>();
        if (parts.length == 1 && parts[0].isBlank()) {
            return list;
        }
        for (String part : parts) {
            try {
                list.add(NodeId.of((long)Long.parseLong(part.strip())));
            }
            catch (NumberFormatException e) {
                SavedStateMetadata.throwInvalidRequiredField(field, value, e);
                return null;
            }
        }
        return list;
    }

    @Nullable
    private static Hash parseHash(@NonNull Map<SavedStateMetadataField, String> data, @NonNull SavedStateMetadataField field) {
        if (!data.containsKey((Object)field)) {
            SavedStateMetadata.logMissingField(field);
            return null;
        }
        String value = data.get((Object)field);
        if (value.equalsIgnoreCase("null")) {
            return null;
        }
        try {
            return new Hash(CommonUtils.unhex((String)value));
        }
        catch (IllegalArgumentException e) {
            SavedStateMetadata.logInvalidField(field, value, e);
            return null;
        }
    }

    @NonNull
    private static Hash parseNonNullHash(@NonNull Map<SavedStateMetadataField, String> data, @NonNull SavedStateMetadataField field) throws IOException {
        if (!data.containsKey((Object)field)) {
            SavedStateMetadata.throwMissingRequiredField(field);
            return null;
        }
        String value = data.get((Object)field);
        try {
            return new Hash(CommonUtils.unhex((String)value));
        }
        catch (IllegalArgumentException e) {
            SavedStateMetadata.throwInvalidRequiredField(field, value, e);
            return null;
        }
    }

    @NonNull
    private static String toStringWithoutNewlines(@Nullable Object value) {
        return value == null ? "null" : value.toString().replace("\n", "//");
    }

    private static void putRequireNonNull(@NonNull Map<SavedStateMetadataField, String> map, @NonNull SavedStateMetadataField field, @NonNull Object value) {
        Objects.requireNonNull(field);
        Objects.requireNonNull(value);
        map.put(field, SavedStateMetadata.toStringWithoutNewlines(value));
    }

    private static void putPossiblyNullObject(@NonNull Map<SavedStateMetadataField, String> map, @NonNull SavedStateMetadataField field, @Nullable Object value) {
        Objects.requireNonNull(field);
        map.put(field, SavedStateMetadata.toStringWithoutNewlines(value));
    }

    private Map<SavedStateMetadataField, String> buildStringMap() {
        EnumMap<SavedStateMetadataField, String> map = new EnumMap<SavedStateMetadataField, String>(SavedStateMetadataField.class);
        SavedStateMetadata.putRequireNonNull(map, SavedStateMetadataField.ROUND, this.round);
        SavedStateMetadata.putRequireNonNull(map, SavedStateMetadataField.HASH, this.hash);
        SavedStateMetadata.putRequireNonNull(map, SavedStateMetadataField.HASH_MNEMONIC, this.hashMnemonic);
        SavedStateMetadata.putRequireNonNull(map, SavedStateMetadataField.NUMBER_OF_CONSENSUS_EVENTS, this.numberOfConsensusEvents);
        SavedStateMetadata.putRequireNonNull(map, SavedStateMetadataField.CONSENSUS_TIMESTAMP, this.consensusTimestamp);
        SavedStateMetadata.putRequireNonNull(map, SavedStateMetadataField.LEGACY_RUNNING_EVENT_HASH, this.legacyRunningEventHash);
        SavedStateMetadata.putRequireNonNull(map, SavedStateMetadataField.LEGACY_RUNNING_EVENT_HASH_MNEMONIC, this.legacyRunningEventHashMnemonic);
        SavedStateMetadata.putRequireNonNull(map, SavedStateMetadataField.MINIMUM_BIRTH_ROUND_NON_ANCIENT, this.minimumBirthRoundNonAncient);
        SavedStateMetadata.putRequireNonNull(map, SavedStateMetadataField.SOFTWARE_VERSION, this.softwareVersion);
        SavedStateMetadata.putRequireNonNull(map, SavedStateMetadataField.WALL_CLOCK_TIME, this.wallClockTime);
        SavedStateMetadata.putRequireNonNull(map, SavedStateMetadataField.NODE_ID, this.nodeId);
        SavedStateMetadata.putRequireNonNull(map, SavedStateMetadataField.SIGNING_NODES, StringFormattingUtils.formattedList(this.signingNodes.iterator()));
        SavedStateMetadata.putRequireNonNull(map, SavedStateMetadataField.SIGNING_WEIGHT_SUM, this.signingWeightSum);
        SavedStateMetadata.putRequireNonNull(map, SavedStateMetadataField.TOTAL_WEIGHT, this.totalWeight);
        SavedStateMetadata.putPossiblyNullObject(map, SavedStateMetadataField.FREEZE_STATE, this.freezeState);
        return map;
    }

    public void write(Path metadataFile) throws IOException {
        Map<SavedStateMetadataField, String> map = this.buildStringMap();
        ArrayList<SavedStateMetadataField> keys = new ArrayList<SavedStateMetadataField>(map.keySet());
        Collections.sort(keys);
        TextTable table = new TextTable().setBordersEnabled(false);
        for (SavedStateMetadataField key : keys) {
            String keyString = key.toString() + ": ";
            String valueString = map.get((Object)key);
            table.addRow(new Object[]{keyString, valueString});
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(metadataFile.toFile()));){
            writer.write(table.render());
        }
    }
}

