/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.DoubleSet;
import org.eclipse.collections.api.set.primitive.ImmutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.tuple.primitive.DoubleDoublePair;
import org.eclipse.collections.impl.collection.mutable.primitive.AbstractSynchronizedDoubleCollection;
import org.eclipse.collections.impl.factory.primitive.DoubleSets;
import org.eclipse.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import org.eclipse.collections.impl.set.mutable.SynchronizedMutableSet;
import org.eclipse.collections.impl.set.mutable.primitive.BoxedMutableDoubleSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;

public class SynchronizedDoubleSet
extends AbstractSynchronizedDoubleCollection
implements MutableDoubleSet {
    private static final long serialVersionUID = 1L;

    public SynchronizedDoubleSet(MutableDoubleSet set) {
        super((MutableDoubleCollection)set);
    }

    public SynchronizedDoubleSet(MutableDoubleSet set, Object newLock) {
        super((MutableDoubleCollection)set, newLock);
    }

    public static SynchronizedDoubleSet of(MutableDoubleSet set) {
        return new SynchronizedDoubleSet(set);
    }

    public static SynchronizedDoubleSet of(MutableDoubleSet set, Object lock) {
        return new SynchronizedDoubleSet(set, lock);
    }

    private MutableDoubleSet getMutableDoubleSet() {
        return (MutableDoubleSet)this.getDoubleCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedDoubleSet without(double element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableDoubleSet().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSet<Double> boxed() {
        Object object = this.getLock();
        synchronized (object) {
            return SynchronizedMutableSet.of(new BoxedMutableDoubleSet(this), this.getLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedDoubleSet with(double element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableDoubleSet().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedDoubleSet withAll(DoubleIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableDoubleSet().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedDoubleSet withoutAll(DoubleIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableDoubleSet().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleSet select(DoublePredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleSet().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleSet reject(DoublePredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleSet().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableSet<V> collect(DoubleToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleSet().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyIterable<DoubleDoublePair> cartesianProduct(DoubleSet set) {
        Object object = this.getLock();
        synchronized (object) {
            return DoubleSets.cartesianProduct((DoubleSet)this, set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object otherSet) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleSet().equals(otherSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleSet().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyDoubleIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyDoubleIterableAdapter((DoubleIterable)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleSet asUnmodifiable() {
        Object object = this.getLock();
        synchronized (object) {
            return new UnmodifiableDoubleSet(this);
        }
    }

    public MutableDoubleSet asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoubleSet freeze() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleSet().freeze();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableDoubleSet toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleSet().toImmutable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleSet newEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleSet().newEmpty();
        }
    }
}

