/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.assertj.core.util.Preconditions;

public class URLs {
    private URLs() {
    }

    public static String contentOf(URL url, String charsetName) {
        URLs.checkArgumentCharsetIsSupported(charsetName);
        return URLs.contentOf(url, Charset.forName(charsetName));
    }

    public static String contentOf(URL url, Charset charset) {
        Objects.requireNonNull(charset, "The charset should not be null");
        try {
            return URLs.loadContents(url.openStream(), charset);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read " + url, e);
        }
    }

    public static List<String> linesOf(URL url, Charset charset) {
        Objects.requireNonNull(charset, "The charset should not be null");
        try {
            return URLs.loadLines(url.openStream(), charset);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read " + url, e);
        }
    }

    public static List<String> linesOf(URL url, String charsetName) {
        URLs.checkArgumentCharsetIsSupported(charsetName);
        return URLs.linesOf(url, Charset.forName(charsetName));
    }

    private static String loadContents(InputStream stream, Charset charset) throws IOException {
        try (StringWriter writer = new StringWriter();){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));){
                int c;
                while ((c = reader.read()) != -1) {
                    writer.write(c);
                }
                string = writer.toString();
            }
            return string;
        }
    }

    private static List<String> loadLines(InputStream stream, Charset charset) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));){
            List<String> list = reader.lines().collect(Collectors.toList());
            return list;
        }
    }

    private static void checkArgumentCharsetIsSupported(String charsetName) {
        Preconditions.checkArgument(Charset.isSupported(charsetName), "Charset:<'%s'> is not supported on this system", charsetName);
    }
}

