/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.lifecycle;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.util.HapiUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.lifecycle.MigrationContext;
import com.swirlds.state.lifecycle.StateDefinition;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public abstract class Schema
implements Comparable<Schema> {
    private final SemanticVersion version;

    protected Schema(@NonNull SemanticVersion version) {
        this.version = Objects.requireNonNull(version);
    }

    @NonNull
    public SemanticVersion getVersion() {
        return this.version;
    }

    @NonNull
    public Set<StateDefinition> statesToCreate() {
        return Collections.emptySet();
    }

    @NonNull
    public Set<StateDefinition> statesToCreate(@NonNull Configuration configuration) {
        return this.statesToCreate();
    }

    public void migrate(@NonNull MigrationContext ctx) {
        Objects.requireNonNull(ctx);
    }

    @NonNull
    public Set<Integer> statesToRemove() {
        return Collections.emptySet();
    }

    public void restart(@NonNull MigrationContext ctx) {
        Objects.requireNonNull(ctx);
    }

    @Override
    public int compareTo(Schema o) {
        return HapiUtils.SEMANTIC_VERSION_COMPARATOR.compare(this.version, o.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Schema)) {
            return false;
        }
        Schema other = (Schema)o;
        return this.version.equals((Object)other.version);
    }

    public int hashCode() {
        return this.version.hashCode();
    }
}

