/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.iterators.internal;

import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.iterators.internal.PostOrderedDepthFirstAlgorithm;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import java.util.function.ObjIntConsumer;

public class PostOrderedDepthFirstRandomAlgorithm
extends PostOrderedDepthFirstAlgorithm {
    private final Random random = new Random();

    @Override
    public void pushChildren(@NonNull MerkleInternal parent, @NonNull ObjIntConsumer<MerkleInternal> pushNode) {
        int childCount = parent.getNumberOfChildren();
        ArrayList<Integer> iterationOrder = new ArrayList<Integer>(childCount);
        for (int childIndex = 0; childIndex < childCount; ++childIndex) {
            iterationOrder.add(childIndex);
        }
        Collections.shuffle(iterationOrder, this.random);
        Iterator iterator = iterationOrder.iterator();
        while (iterator.hasNext()) {
            int childIndex = (Integer)iterator.next();
            pushNode.accept(parent, childIndex);
        }
    }
}

