/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.stream.internal;

import com.swirlds.base.utility.Pair;
import com.swirlds.common.stream.LinkedObjectStreamUtilities;
import com.swirlds.common.stream.StreamType;
import com.swirlds.common.stream.internal.InvalidStreamFileException;
import com.swirlds.common.stream.internal.StreamValidationResult;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.StreamParseErrorPayload;
import java.io.File;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.CryptographyProvider;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.SignatureType;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.utility.CommonUtils;

public final class LinkedObjectStreamValidateUtils {
    private static final Logger logger = LogManager.getLogger(LinkedObjectStreamValidateUtils.class);
    private static final Cryptography CRYPTOGRAPHY = CryptographyProvider.getInstance();

    private LinkedObjectStreamValidateUtils() {
    }

    public static StreamValidationResult validateFileAndSignature(File streamFile, File sigFile, PublicKey publicKey, StreamType streamType) {
        StreamValidationResult result;
        try {
            Pair<StreamValidationResult, Hash> objectResult = LinkedObjectStreamValidateUtils.validateDirOrFile(streamFile, streamType);
            if (objectResult.left() != StreamValidationResult.OK) {
                return (StreamValidationResult)((Object)objectResult.left());
            }
            Hash entireHash = LinkedObjectStreamUtilities.computeEntireHash(streamFile);
            result = LinkedObjectStreamValidateUtils.validateSignature(entireHash, sigFile, publicKey, streamType);
        }
        catch (InvalidStreamFileException ex) {
            logger.error(LogMarker.EXCEPTION.getMarker(), () -> new StreamParseErrorPayload(String.format("validateFileAndSignature : failed to validate file %s", streamFile.getName())), (Throwable)ex);
            result = StreamValidationResult.PARSE_STREAM_FILE_FAIL;
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            logger.error(LogMarker.EXCEPTION.getMarker(), () -> new StreamParseErrorPayload(String.format("validateFileAndSignature : failed to calculate entireHash for %s", streamFile.getName())), (Throwable)ex);
            result = StreamValidationResult.FAIL_TO_CALCULATE_ENTIRE_HASH;
        }
        return result;
    }

    public static StreamValidationResult validateSignature(Hash entireHash, File sigFile, PublicKey publicKey, StreamType streamType) {
        StreamValidationResult result;
        Pair<Pair<Hash, org.hiero.base.crypto.Signature>, Pair<Hash, org.hiero.base.crypto.Signature>> parsedPairs;
        try {
            parsedPairs = LinkedObjectStreamUtilities.parseSigFile(sigFile, streamType);
        }
        catch (InvalidStreamFileException | IOException | IllegalArgumentException ex) {
            logger.error(LogMarker.EXCEPTION.getMarker(), () -> new StreamParseErrorPayload(String.format("parseSigFile : fail to read signature from File %s", sigFile.getName())), (Throwable)ex);
            return StreamValidationResult.PARSE_SIG_FILE_FAIL;
        }
        Hash entireHashInSig = (Hash)((Pair)parsedPairs.left()).left();
        if (!entireHash.equals((Object)entireHashInSig)) {
            result = StreamValidationResult.SIG_HASH_NOT_MATCH_FILE;
        } else {
            org.hiero.base.crypto.Signature entireSignature = (org.hiero.base.crypto.Signature)((Pair)parsedPairs.left()).right();
            Hash metaHashInSig = (Hash)((Pair)parsedPairs.right()).left();
            org.hiero.base.crypto.Signature metaSignature = (org.hiero.base.crypto.Signature)((Pair)parsedPairs.right()).right();
            result = !LinkedObjectStreamValidateUtils.verifySignature(entireHash, entireSignature, publicKey) ? StreamValidationResult.INVALID_ENTIRE_SIGNATURE : (!LinkedObjectStreamValidateUtils.verifySignature(metaHashInSig, metaSignature, publicKey) ? StreamValidationResult.INVALID_META_SIGNATURE : StreamValidationResult.OK);
        }
        return result;
    }

    public static Pair<StreamValidationResult, Hash> validateDirOrFile(File objectDirOrFile, StreamType streamType) throws InvalidStreamFileException {
        return LinkedObjectStreamValidateUtils.validateIterator(LinkedObjectStreamUtilities.parseStreamDirOrFile(objectDirOrFile, streamType));
    }

    public static Pair<StreamValidationResult, Hash> validateFileList(List<File> fileList, StreamType streamType) {
        return LinkedObjectStreamValidateUtils.validateIterator(LinkedObjectStreamUtilities.parseStreamFileList(fileList, streamType));
    }

    public static <T extends SelfSerializable> Pair<StreamValidationResult, Hash> validateIterator(Iterator<T> iterator) {
        if (iterator == null) {
            return Pair.of((Object)((Object)StreamValidationResult.PARSE_STREAM_FILE_FAIL), null);
        }
        if (!iterator.hasNext()) {
            return Pair.of((Object)((Object)StreamValidationResult.STREAM_FILE_EMPTY), null);
        }
        SelfSerializable first = (SelfSerializable)iterator.next();
        if (!(first instanceof Hash)) {
            return Pair.of((Object)((Object)StreamValidationResult.STREAM_FILE_MISS_START_HASH), null);
        }
        Hash runningHash = (Hash)first;
        SelfSerializable selfSerializable = null;
        int objectsCount = 0;
        while (iterator.hasNext()) {
            selfSerializable = (SelfSerializable)iterator.next();
            if (!iterator.hasNext() && selfSerializable instanceof Hash) break;
            ++objectsCount;
            Hash objectHash = CRYPTOGRAPHY.digestSync(selfSerializable);
            runningHash = CRYPTOGRAPHY.calcRunningHash(runningHash, objectHash);
            logger.info(LogMarker.OBJECT_STREAM.getMarker(), "validateIterator :: after consuming object {},hash: {}, updated runningHash: {}", (Object)selfSerializable, (Object)objectHash, (Object)runningHash);
        }
        if (objectsCount == 0) {
            return Pair.of((Object)((Object)StreamValidationResult.STREAM_FILE_MISS_OBJECTS), null);
        }
        if (!(selfSerializable instanceof Hash)) {
            return Pair.of((Object)((Object)StreamValidationResult.STREAM_FILE_MISS_END_HASH), null);
        }
        Hash endHash = (Hash)selfSerializable;
        if (!runningHash.equals((Object)endHash)) {
            logger.info(LogMarker.EXCEPTION.getMarker(), "calculated: {}, read: {}", (Object)runningHash, (Object)endHash);
            return Pair.of((Object)((Object)StreamValidationResult.CALCULATED_END_HASH_NOT_MATCH), (Object)endHash);
        }
        return Pair.of((Object)((Object)StreamValidationResult.OK), (Object)endHash);
    }

    public static boolean verifySignature(Hash hash, org.hiero.base.crypto.Signature signature, PublicKey publicKey) {
        try {
            Signature sig = Signature.getInstance(SignatureType.RSA.signingAlgorithm(), SignatureType.RSA.provider());
            sig.initVerify(publicKey);
            hash.getBytes().updateSignature(sig);
            return signature.getBytes().verifySignature(sig);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), () -> "Failed to verify Signature: %s, PublicKey: %s".formatted(signature, CommonUtils.hex((byte[])publicKey.getEncoded())), (Throwable)e);
            return false;
        }
    }
}

