/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.signed;

import com.swirlds.common.FastCopyable;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hiero.base.crypto.Signature;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.consensus.model.node.NodeId;

public class SigSet
implements FastCopyable,
Iterable<NodeId>,
SelfSerializable {
    private static final long CLASS_ID = 8461435669949082258L;
    public static final int MAX_SIGNATURE_COUNT = 1024;
    private final Map<NodeId, Signature> signatures = new HashMap<NodeId, Signature>();

    public SigSet() {
    }

    private SigSet(SigSet that) {
        this.signatures.putAll(that.signatures);
    }

    public void addSignature(@NonNull NodeId nodeId, @NonNull Signature signature) {
        Objects.requireNonNull(nodeId, "nodeId must not be null");
        Objects.requireNonNull(signature, "signature must not be null");
        this.signatures.put(nodeId, signature);
    }

    public void removeSignature(@NonNull NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId must not be null");
        this.signatures.remove(nodeId);
    }

    @Nullable
    public Signature getSignature(@NonNull NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId must not be null");
        return this.signatures.get(nodeId);
    }

    public boolean hasSignature(@NonNull NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId must not be null");
        return this.signatures.containsKey(nodeId);
    }

    @Override
    @NonNull
    public Iterator<NodeId> iterator() {
        final Iterator<NodeId> iterator = this.signatures.keySet().iterator();
        return new Iterator<NodeId>(this){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public NodeId next() {
                return (NodeId)iterator.next();
            }
        };
    }

    @NonNull
    public List<NodeId> getSigningNodes() {
        return new ArrayList<NodeId>(this.signatures.keySet());
    }

    public int size() {
        return this.signatures.size();
    }

    @NonNull
    public SigSet copy() {
        return new SigSet(this);
    }

    public int getMinimumSupportedVersion() {
        return 3;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeInt(this.signatures.size());
        ArrayList sortedIds = new ArrayList(this.signatures.size());
        this.signatures.keySet().stream().sorted().forEachOrdered(sortedIds::add);
        for (NodeId nodeId : sortedIds) {
            out.writeSerializable((SelfSerializable)nodeId, false);
            this.signatures.get(nodeId).serialize(out, false);
        }
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        int signatureCount = in.readInt();
        if (signatureCount > 1024) {
            throw new IOException("Signature count of " + signatureCount + " exceeds maximum of 1024");
        }
        for (int index = 0; index < signatureCount; ++index) {
            NodeId nodeId = version < 4 ? NodeId.of((long)in.readLong()) : (NodeId)in.readSerializable(false, NodeId::new);
            Signature signature = Signature.deserialize((SerializableDataInputStream)in, (boolean)false);
            this.signatures.put(nodeId, signature);
        }
    }

    public long getClassId() {
        return 8461435669949082258L;
    }

    public int getVersion() {
        return 4;
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;
        public static final int MIGRATE_TO_SERIALIZABLE = 2;
        public static final int CLEANUP = 3;
        public static final int SELF_SERIALIZABLE_NODE_ID = 4;

        private ClassVersion() {
        }
    }
}

