/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.snapshot;

import com.swirlds.common.config.StateCommonConfig;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.state.snapshot.SavedStateInfo;
import com.swirlds.platform.state.snapshot.SavedStateMetadata;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.node.NodeId;

public class SignedStateFilePath {
    private static final Logger logger = LogManager.getLogger(SignedStateFilePath.class);
    final StateCommonConfig stateConfig;

    public SignedStateFilePath(@NonNull StateCommonConfig stateConfig) {
        this.stateConfig = stateConfig;
    }

    @NonNull
    public Path getSignedStatesBaseDirectory() {
        return FileUtils.getAbsolutePath((Path)this.stateConfig.savedStateDirectory());
    }

    @NonNull
    public Path getSignedStatesDirectoryForApp(String mainClassName) {
        return this.getSignedStatesBaseDirectory().resolve(mainClassName);
    }

    @NonNull
    public Path getSignedStatesDirectoryForNode(String mainClassName, NodeId selfId) {
        return this.getSignedStatesDirectoryForApp(mainClassName).resolve(selfId.toString());
    }

    @NonNull
    public Path getSignedStatesDirectoryForSwirld(String mainClassName, NodeId selfId, String swirldName) {
        return this.getSignedStatesDirectoryForNode(mainClassName, selfId).resolve(swirldName);
    }

    @NonNull
    public Path getSignedStateDirectory(String mainClassName, NodeId selfId, String swirldName, long round) {
        return this.getSignedStatesDirectoryForSwirld(mainClassName, selfId, swirldName).resolve(Long.toString(round));
    }

    @NonNull
    public List<SavedStateInfo> getSavedStateFiles(String mainClassName, NodeId platformId, String swirldName) {
        Path dir = this.getSignedStatesDirectoryForSwirld(mainClassName, platformId, swirldName);
        return SignedStateFilePath.getSavedStateFiles(dir);
    }

    public static List<SavedStateInfo> getSavedStateFiles(Path dir) {
        ArrayList arrayList;
        block15: {
            if (!Files.exists(dir, new LinkOption[0]) || !Files.isDirectory(dir, new LinkOption[0])) {
                return List.of();
            }
            Stream<Path> list = Files.list(dir);
            try {
                List<Path> dirs = list.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).toList();
                TreeMap<Long, SavedStateInfo> savedStates = new TreeMap<Long, SavedStateInfo>();
                for (Path subDir : dirs) {
                    try {
                        SavedStateMetadata metadata;
                        long round = Long.parseLong(subDir.getFileName().toString());
                        Path stateFile = subDir.resolve("SignedState.swh");
                        if (!Files.exists(stateFile, new LinkOption[0])) {
                            logger.warn(LogMarker.EXCEPTION.getMarker(), "Saved state file ({}) not found, but directory exists '{}'", (Object)stateFile.getFileName(), (Object)subDir.toAbsolutePath());
                            continue;
                        }
                        Path metdataPath = subDir.resolve("stateMetadata.txt");
                        try {
                            metadata = SavedStateMetadata.parse(metdataPath);
                        }
                        catch (IOException e) {
                            logger.error(LogMarker.EXCEPTION.getMarker(), "Unable to read saved state metadata file '{}'", (Object)metdataPath);
                            continue;
                        }
                        savedStates.put(round, new SavedStateInfo(stateFile, metadata));
                    }
                    catch (NumberFormatException e) {
                        logger.warn(LogMarker.EXCEPTION.getMarker(), "Unexpected directory '{}' in '{}'", (Object)subDir.getFileName(), (Object)dir.toAbsolutePath());
                    }
                }
                arrayList = new ArrayList(savedStates.descendingMap().values());
                if (list == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (list != null) {
                        try {
                            list.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            list.close();
        }
        return arrayList;
    }
}

