/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.block.stream.trace.codec;

import com.hedera.hapi.block.stream.trace.ContractSlotUsage;
import com.hedera.hapi.block.stream.trace.EvmTraceData;
import com.hedera.hapi.block.stream.trace.EvmTransactionLog;
import com.hedera.hapi.block.stream.trace.ExecutedInitcode;
import com.hedera.hapi.streams.ContractAction;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class EvmTraceDataJsonCodec
implements JsonCodec<EvmTraceData> {
    @NonNull
    public EvmTraceData parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            List temp_contract_actions = Collections.emptyList();
            List temp_contract_slot_usages = Collections.emptyList();
            String temp_error_details = "";
            ExecutedInitcode temp_executed_initcode = null;
            List temp_logs = Collections.emptyList();
            block16: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "contractActions": {
                        temp_contract_actions = JsonTools.parseObjArray((List)JsonTools.checkSize((String)"contract_actions", (List)kvPair.value().arr().value(), (int)maxSize), ContractAction.JSON, (int)(maxDepth - 1), (int)maxSize);
                        continue block16;
                    }
                    case "contractSlotUsages": {
                        temp_contract_slot_usages = JsonTools.parseObjArray((List)JsonTools.checkSize((String)"contract_slot_usages", (List)kvPair.value().arr().value(), (int)maxSize), ContractSlotUsage.JSON, (int)(maxDepth - 1), (int)maxSize);
                        continue block16;
                    }
                    case "errorDetails": {
                        temp_error_details = JsonTools.unescape((String)JsonTools.checkSize((String)"error_details", (String)kvPair.value().STRING().getText(), (int)maxSize));
                        continue block16;
                    }
                    case "executedInitcode": {
                        temp_executed_initcode = (ExecutedInitcode)ExecutedInitcode.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block16;
                    }
                    case "logs": {
                        temp_logs = JsonTools.parseObjArray((List)JsonTools.checkSize((String)"logs", (List)kvPair.value().arr().value(), (int)maxSize), EvmTransactionLog.JSON, (int)(maxDepth - 1), (int)maxSize);
                        continue block16;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new EvmTraceData(temp_contract_actions, temp_contract_slot_usages, temp_error_details, temp_executed_initcode, temp_logs);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull EvmTraceData data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (!data.contractActions().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"contractActions", ContractAction.JSON, data.contractActions()));
        }
        if (!data.contractSlotUsages().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"contractSlotUsages", ContractSlotUsage.JSON, data.contractSlotUsages()));
        }
        if (data.errorDetails() != "") {
            fieldLines.add(JsonTools.field((String)"errorDetails", (String)data.errorDetails()));
        }
        if (data.executedInitcode() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"executedInitcode", ExecutedInitcode.JSON, (Object)data.executedInitcode()));
        }
        if (!data.logs().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"logs", EvmTransactionLog.JSON, data.logs()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

