/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.migration;

import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.impl.PartialMerkleLeaf;
import java.io.IOException;
import java.util.Objects;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class InternalValue
extends PartialMerkleLeaf
implements MerkleLeaf {
    public static final long CLASS_ID = -6094795881748116928L;
    private long balance;
    private long expirationTime;
    private long autoRenewPeriod;
    private long senderThreshold;
    private long receiverThreshold;
    private String memo;
    private boolean isSmartContract;
    private boolean receiverSigRequired;

    public InternalValue() {
    }

    public InternalValue(long balance, long expirationTime, long autoRenewPeriod, long senderThreshold, long receiverThreshold, String memo, boolean isSmartContract, boolean receiverSigRequired) {
        this.balance = balance;
        this.expirationTime = expirationTime;
        this.autoRenewPeriod = autoRenewPeriod;
        this.senderThreshold = senderThreshold;
        this.receiverThreshold = receiverThreshold;
        this.memo = memo;
        this.isSmartContract = isSmartContract;
        this.receiverSigRequired = receiverSigRequired;
    }

    private InternalValue(InternalValue internalValue) {
        super((PartialMerkleLeaf)internalValue);
        this.balance = internalValue.balance;
        this.expirationTime = internalValue.expirationTime;
        this.autoRenewPeriod = internalValue.autoRenewPeriod;
        this.senderThreshold = internalValue.senderThreshold;
        this.receiverThreshold = internalValue.receiverThreshold;
        this.memo = internalValue.memo;
        this.isSmartContract = internalValue.isSmartContract;
        this.receiverSigRequired = internalValue.receiverSigRequired;
    }

    public InternalValue copy() {
        this.throwIfImmutable();
        return new InternalValue(this);
    }

    public long getClassId() {
        return -6094795881748116928L;
    }

    public int getVersion() {
        return 1;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        InternalValue that = (InternalValue)((Object)other);
        return this.balance == that.balance && this.expirationTime == that.expirationTime && this.autoRenewPeriod == that.autoRenewPeriod && this.senderThreshold == that.senderThreshold && this.receiverThreshold == that.receiverThreshold && this.isSmartContract == that.isSmartContract && this.receiverSigRequired == that.receiverSigRequired && Objects.equals(this.memo, that.memo);
    }

    public int hashCode() {
        return Objects.hash(this.balance, this.expirationTime, this.autoRenewPeriod, this.senderThreshold, this.receiverThreshold, this.memo, this.isSmartContract, this.receiverSigRequired);
    }

    public void serialize(SerializableDataOutputStream outStream) throws IOException {
        outStream.writeLong(this.balance);
        outStream.writeLong(this.expirationTime);
        outStream.writeLong(this.autoRenewPeriod);
        outStream.writeLong(this.senderThreshold);
        outStream.writeLong(this.receiverThreshold);
        outStream.writeBoolean(this.isSmartContract);
        outStream.writeBoolean(this.receiverSigRequired);
        byte[] memoData = this.memo.getBytes();
        outStream.writeByteArray(memoData);
    }

    public void deserialize(SerializableDataInputStream inStream, int version) throws IOException {
        this.copyFromVersion1(inStream);
        this.copyFromMemoVersion1(inStream);
    }

    public void copyFromVersion1(SerializableDataInputStream inStream) throws IOException {
        this.balance = inStream.readLong();
        this.expirationTime = inStream.readLong();
        this.autoRenewPeriod = inStream.readLong();
        this.senderThreshold = inStream.readLong();
        this.receiverThreshold = inStream.readLong();
        this.isSmartContract = inStream.readBoolean();
        this.receiverSigRequired = inStream.readBoolean();
    }

    public void copyFromMemoVersion1(SerializableDataInputStream inStream) throws IOException {
        byte[] memoData = inStream.readByteArray(Integer.MAX_VALUE);
        this.memo = new String(memoData);
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

