/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.logging;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TopicID;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.internal.merkle.VirtualLeafNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StateLogger {
    private static final Logger logger = LogManager.getLogger(StateLogger.class);
    private static final String TRANSACTION_HANDLING_THREAD_NAME = "<scheduler TransactionHandler>";

    public static <T> void logSingletonRead(@NonNull String label, @Nullable T value) {
        if (logger.isDebugEnabled() && Thread.currentThread().getName().equals(TRANSACTION_HANDLING_THREAD_NAME)) {
            logger.debug("      READ singleton {} value {}", (Object)label, (Object)(value == null ? "null" : value.toString()));
        }
    }

    public static <T> void logSingletonWrite(@NonNull String label, @Nullable T value) {
        if (logger.isDebugEnabled() && Thread.currentThread().getName().equals(TRANSACTION_HANDLING_THREAD_NAME)) {
            logger.debug("      WRITTEN singleton {} value {}", (Object)label, (Object)(value == null ? "null" : value.toString()));
        }
    }

    public static <T> void logSingletonRemove(@NonNull String label, @Nullable T value) {
        if (logger.isDebugEnabled() && Thread.currentThread().getName().equals(TRANSACTION_HANDLING_THREAD_NAME)) {
            logger.debug("      REMOVE from singleton {} value {}", (Object)label, (Object)(value == null ? "null" : value.toString()));
        }
    }

    public static <T> void logQueueAdd(@NonNull String label, @Nullable T value) {
        if (logger.isDebugEnabled() && Thread.currentThread().getName().equals(TRANSACTION_HANDLING_THREAD_NAME)) {
            logger.debug("      ADD to queue {} value {}", (Object)label, (Object)(value == null ? "null" : value.toString()));
        }
    }

    public static <T> void logQueueRemove(@NonNull String label, @Nullable T value) {
        if (logger.isDebugEnabled() && Thread.currentThread().getName().equals(TRANSACTION_HANDLING_THREAD_NAME)) {
            logger.debug("      REMOVE from queue {} value {}", (Object)label, (Object)(value == null ? "null" : value.toString()));
        }
    }

    public static <T> void logQueuePeek(@NonNull String label, @Nullable T value) {
        if (logger.isDebugEnabled() && Thread.currentThread().getName().equals(TRANSACTION_HANDLING_THREAD_NAME)) {
            logger.debug("      PEEK on queue {} value {}", (Object)label, (Object)(value == null ? "null" : value.toString()));
        }
    }

    public static <K> void logQueueIterate(@NonNull String label, long size, @NonNull Iterator<K> it) {
        if (logger.isDebugEnabled() && Thread.currentThread().getName().equals(TRANSACTION_HANDLING_THREAD_NAME)) {
            if (size == 0L) {
                logger.debug("      ITERATE queue {} size 0 values:EMPTY", (Object)label);
            } else {
                Iterable iterable = () -> it;
                logger.debug("      ITERATE queue {} size {} values:\n{}", (Object)label, (Object)size, (Object)StreamSupport.stream(iterable.spliterator(), false).map(leaf -> leaf == null ? "null" : leaf.toString()).collect(Collectors.joining(",\n")));
            }
        }
    }

    public static <K, V> void logMapPut(@NonNull String label, @NonNull K key, @Nullable V value) {
        if (logger.isDebugEnabled() && Thread.currentThread().getName().equals(TRANSACTION_HANDLING_THREAD_NAME)) {
            logger.debug("      PUT into map {} key {} value {}", (Object)label, (Object)StateLogger.formatKey(key), (Object)(value == null ? "null" : value.toString()));
        }
    }

    public static <K, V> void logMapRemove(@NonNull String label, @NonNull K key, @Nullable V value) {
        if (logger.isDebugEnabled() && Thread.currentThread().getName().equals(TRANSACTION_HANDLING_THREAD_NAME)) {
            logger.debug("      REMOVE from map {} key {} removed value {}", (Object)label, (Object)StateLogger.formatKey(key), (Object)(value == null ? "null" : value.toString()));
        }
    }

    public static void logMapGetSize(@NonNull String label, long size) {
        if (logger.isDebugEnabled() && Thread.currentThread().getName().equals(TRANSACTION_HANDLING_THREAD_NAME)) {
            logger.debug("      GET_SIZE on map {} size {}", (Object)label, (Object)size);
        }
    }

    public static <K, V> void logMapGet(@NonNull String label, @NonNull K key, @Nullable V value) {
        if (logger.isDebugEnabled() && Thread.currentThread().getName().equals(TRANSACTION_HANDLING_THREAD_NAME)) {
            logger.debug("      GET on map {} key {} value {}", (Object)label, (Object)StateLogger.formatKey(key), (Object)(value == null ? "null" : value.toString()));
        }
    }

    public static <K> void logMapIterate(@NonNull String label, @NonNull VirtualMap virtualMap, @NonNull Codec<K> keyCodec) {
        if (logger.isDebugEnabled()) {
            Spliterator spliterator = Spliterators.spliterator(virtualMap.treeIterator(), virtualMap.size(), 0);
            long size = virtualMap.size();
            if (size == 0L) {
                logger.debug("      ITERATE keys of {} state size 0 keys:EMPTY", (Object)label);
            } else {
                AtomicInteger count = new AtomicInteger(0);
                String keys = StreamSupport.stream(spliterator, false).map(merkleNode -> {
                    if (merkleNode instanceof VirtualLeafNode) {
                        VirtualLeafNode leaf = (VirtualLeafNode)merkleNode;
                        Bytes k = leaf.getKey();
                        String result = null;
                        try {
                            result = keyCodec.parse(k).toString();
                            count.incrementAndGet();
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                        return result;
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.joining(",\n"));
                logger.debug("      ITERATE keys of {} state (size {}) keys:\n{}", (Object)label, (Object)count.get(), (Object)keys);
            }
        }
    }

    public static <K> String formatKey(@Nullable K key) {
        if (key == null) {
            return "null";
        }
        if (key instanceof AccountID) {
            AccountID accountID = (AccountID)key;
            return accountID.shardNum() + "." + accountID.realmNum() + "." + accountID.accountNum();
        }
        if (key instanceof FileID) {
            FileID fileID = (FileID)key;
            return fileID.shardNum() + "." + fileID.realmNum() + "." + fileID.fileNum();
        }
        if (key instanceof TokenID) {
            TokenID tokenID = (TokenID)key;
            return tokenID.shardNum() + "." + tokenID.realmNum() + "." + tokenID.tokenNum();
        }
        if (key instanceof TopicID) {
            TopicID topicID = (TopicID)key;
            return topicID.shardNum() + "." + topicID.realmNum() + "." + topicID.topicNum();
        }
        if (key instanceof ScheduleID) {
            ScheduleID scheduleID = (ScheduleID)key;
            return scheduleID.shardNum() + "." + scheduleID.realmNum() + "." + scheduleID.scheduleNum();
        }
        return key.toString();
    }
}

