/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Objects;

public record StateValue<V>(int stateId, @NonNull V value) {
    public static int extractStateIdFromStateValueOneOf(@NonNull Bytes stateValue) {
        Objects.requireNonNull(stateValue, "Null state value");
        return ProtoParserTools.readNextFieldNumber((ReadableSequentialData)stateValue.toReadableSequentialData());
    }

    public static final class StateValueCodec<V>
    implements Codec<StateValue<V>> {
        private final int stateId;
        private final Codec<V> valueCodec;

        public StateValueCodec(int stateId, @NonNull Codec<V> valueCodec) {
            this.stateId = stateId;
            this.valueCodec = Objects.requireNonNull(valueCodec);
        }

        public StateValue<V> getDefaultInstance() {
            return new StateValue<Object>(this.stateId, this.valueCodec.getDefaultInstance());
        }

        public int measureRecord(@NonNull StateValue<V> value) {
            int size = 0;
            int stateId = value.stateId();
            size += ProtoWriterTools.sizeOfVarInt32((int)(stateId << 3 | ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG.ordinal()));
            int valueSize = this.valueCodec.measureRecord(value.value());
            size += ProtoWriterTools.sizeOfVarInt32((int)valueSize);
            if (valueSize > 0) {
                size += valueSize;
            }
            return size;
        }

        public void write(@NonNull StateValue<V> value, @NonNull WritableSequentialData out) throws IOException {
            int stateId = value.stateId();
            out.writeVarInt(stateId << 3 | ProtoConstants.WIRE_TYPE_DELIMITED.ordinal(), false);
            int valueSize = this.valueCodec.measureRecord(value.value());
            out.writeVarInt(valueSize, false);
            if (valueSize > 0) {
                this.valueCodec.write(value.value(), out);
            }
        }

        @NonNull
        public StateValue<V> parse(@NonNull ReadableSequentialData in, boolean strictMode, boolean parseUnknownFields, int maxDepth) throws ParseException {
            Object value;
            int tag = in.readVarInt(false);
            int fieldNum = tag >> 3;
            if (fieldNum != this.stateId) {
                throw new ParseException("State ID num mismatch: expected=" + this.stateId + ", actual=" + fieldNum);
            }
            int wireType = tag & 7;
            if (wireType != ProtoConstants.WIRE_TYPE_DELIMITED.ordinal()) {
                throw new ParseException("State ID wire type mismatch: expected=" + ProtoConstants.WIRE_TYPE_DELIMITED.ordinal() + ", actual=" + wireType);
            }
            int size = in.readVarInt(false);
            if (size == 0) {
                value = this.valueCodec.getDefaultInstance();
            } else {
                long limit = in.limit();
                in.limit(in.position() + (long)size);
                value = this.valueCodec.parse(in, strictMode, parseUnknownFields, maxDepth);
                in.limit(limit);
            }
            return new StateValue<Object>(this.stateId, value);
        }

        public boolean fastEquals(@NonNull StateValue<V> value, @NonNull ReadableSequentialData in) throws ParseException {
            boolean equals;
            int tag = in.readVarInt(false);
            int fieldNum = tag >> 3;
            if (fieldNum != this.stateId) {
                return false;
            }
            int wireType = tag & 7;
            if (wireType != ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG.ordinal()) {
                return false;
            }
            int size = in.readVarInt(false);
            if (size == 0) {
                equals = value.equals(this.valueCodec.getDefaultInstance());
            } else {
                long limit = in.limit();
                in.limit(in.position() + (long)size);
                equals = value.equals(this.valueCodec.parse(in));
                in.limit(limit);
            }
            return equals;
        }

        public int measure(@NonNull ReadableSequentialData in) throws ParseException {
            long start = in.position();
            this.parse(in);
            long end = in.position();
            return (int)(end - start);
        }

        public int hashCode() {
            return Objects.hash(this.stateId, this.valueCodec);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StateValueCodec)) {
                return false;
            }
            StateValueCodec that = (StateValueCodec)obj;
            return Objects.equals(this.stateId, that.stateId) && Objects.equals(this.valueCodec, that.valueCodec);
        }
    }
}

