/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.hash;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hiero.base.crypto.Hash;

public class FutureMerkleHash
implements Future<Hash> {
    private volatile Hash hash;
    private volatile Throwable exception;
    private final CountDownLatch latch = new CountDownLatch(1);

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException();
    }

    public synchronized void cancelWithException(@NonNull Throwable t) {
        if (this.exception == null) {
            this.exception = t;
            this.latch.countDown();
        }
    }

    @Override
    public boolean isCancelled() {
        return this.exception != null;
    }

    @Override
    public boolean isDone() {
        return this.hash != null;
    }

    private void rethrowException() throws ExecutionException {
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
    }

    @Override
    public Hash get() throws InterruptedException, ExecutionException {
        this.latch.await();
        this.rethrowException();
        return this.hash;
    }

    @Override
    public Hash get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        if (!this.latch.await(timeout, unit)) {
            throw new TimeoutException();
        }
        this.rethrowException();
        return this.hash;
    }

    public synchronized void set(Hash hash) {
        if (this.exception == null) {
            this.hash = hash;
            this.latch.countDown();
        }
    }
}

