/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.block.api;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.hiero.block.api.codec.BlockNodeVersionsJsonCodec;
import org.hiero.block.api.codec.BlockNodeVersionsProtoCodec;
import org.hiero.block.api.schema.BlockNodeVersionsSchema;

public final class BlockNodeVersions {
    public static final Codec<BlockNodeVersions> PROTOBUF = new BlockNodeVersionsProtoCodec();
    public static final JsonCodec<BlockNodeVersions> JSON = new BlockNodeVersionsJsonCodec();
    public static final BlockNodeVersions DEFAULT = BlockNodeVersions.newBuilder().build();
    @Nullable
    private final SemanticVersion addressBookVersion;
    @Nullable
    private final SemanticVersion streamProtoVersion;
    @Nullable
    private final SemanticVersion softwareVersion;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public BlockNodeVersions(SemanticVersion addressBookVersion, SemanticVersion streamProtoVersion, SemanticVersion softwareVersion) {
        this.$unknownFields = null;
        this.addressBookVersion = addressBookVersion;
        this.streamProtoVersion = streamProtoVersion;
        this.softwareVersion = softwareVersion;
    }

    public BlockNodeVersions(SemanticVersion addressBookVersion, SemanticVersion streamProtoVersion, SemanticVersion softwareVersion, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.addressBookVersion = addressBookVersion;
        this.streamProtoVersion = streamProtoVersion;
        this.softwareVersion = softwareVersion;
    }

    public SemanticVersion addressBookVersion() {
        return this.addressBookVersion;
    }

    public SemanticVersion streamProtoVersion() {
        return this.streamProtoVersion;
    }

    public SemanticVersion softwareVersion() {
        return this.softwareVersion;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)BlockNodeVersionsSchema.ADDRESS_BOOK_VERSION, (Object)this.addressBookVersion, SemanticVersion.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)BlockNodeVersionsSchema.STREAM_PROTO_VERSION, (Object)this.streamProtoVersion, SemanticVersion.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)BlockNodeVersionsSchema.SOFTWARE_VERSION, (Object)this.softwareVersion, SemanticVersion.PROTOBUF);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.addressBookVersion != null && !this.addressBookVersion.equals(BlockNodeVersions.DEFAULT.addressBookVersion)) {
                result = 31 * result + this.addressBookVersion.hashCode();
            }
            if (this.streamProtoVersion != null && !this.streamProtoVersion.equals(BlockNodeVersions.DEFAULT.streamProtoVersion)) {
                result = 31 * result + this.streamProtoVersion.hashCode();
            }
            if (this.softwareVersion != null && !this.softwareVersion.equals(BlockNodeVersions.DEFAULT.softwareVersion)) {
                result = 31 * result + this.softwareVersion.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        BlockNodeVersions thatObj = (BlockNodeVersions)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.addressBookVersion == null && thatObj.addressBookVersion != null) {
            return false;
        }
        if (this.addressBookVersion != null && !this.addressBookVersion.equals(thatObj.addressBookVersion)) {
            return false;
        }
        if (this.streamProtoVersion == null && thatObj.streamProtoVersion != null) {
            return false;
        }
        if (this.streamProtoVersion != null && !this.streamProtoVersion.equals(thatObj.streamProtoVersion)) {
            return false;
        }
        if (this.softwareVersion == null && thatObj.softwareVersion != null) {
            return false;
        }
        if (this.softwareVersion != null && !this.softwareVersion.equals(thatObj.softwareVersion)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "BlockNodeVersions[addressBookVersion=" + String.valueOf(this.addressBookVersion) + ", streamProtoVersion=" + String.valueOf(this.streamProtoVersion) + ", softwareVersion=" + String.valueOf(this.softwareVersion) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasAddressBookVersion() {
        return this.addressBookVersion != null;
    }

    public SemanticVersion addressBookVersionOrElse(@NonNull SemanticVersion defaultValue) {
        return this.hasAddressBookVersion() ? this.addressBookVersion : defaultValue;
    }

    @NonNull
    public SemanticVersion addressBookVersionOrThrow() {
        return Objects.requireNonNull(this.addressBookVersion, "Field addressBookVersion is null");
    }

    public void ifAddressBookVersion(@NonNull Consumer<SemanticVersion> ifPresent) {
        if (this.hasAddressBookVersion()) {
            ifPresent.accept(this.addressBookVersion);
        }
    }

    public boolean hasStreamProtoVersion() {
        return this.streamProtoVersion != null;
    }

    public SemanticVersion streamProtoVersionOrElse(@NonNull SemanticVersion defaultValue) {
        return this.hasStreamProtoVersion() ? this.streamProtoVersion : defaultValue;
    }

    @NonNull
    public SemanticVersion streamProtoVersionOrThrow() {
        return Objects.requireNonNull(this.streamProtoVersion, "Field streamProtoVersion is null");
    }

    public void ifStreamProtoVersion(@NonNull Consumer<SemanticVersion> ifPresent) {
        if (this.hasStreamProtoVersion()) {
            ifPresent.accept(this.streamProtoVersion);
        }
    }

    public boolean hasSoftwareVersion() {
        return this.softwareVersion != null;
    }

    public SemanticVersion softwareVersionOrElse(@NonNull SemanticVersion defaultValue) {
        return this.hasSoftwareVersion() ? this.softwareVersion : defaultValue;
    }

    @NonNull
    public SemanticVersion softwareVersionOrThrow() {
        return Objects.requireNonNull(this.softwareVersion, "Field softwareVersion is null");
    }

    public void ifSoftwareVersion(@NonNull Consumer<SemanticVersion> ifPresent) {
        if (this.hasSoftwareVersion()) {
            ifPresent.accept(this.softwareVersion);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.addressBookVersion, this.streamProtoVersion, this.softwareVersion, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private SemanticVersion addressBookVersion = null;
        @Nullable
        private SemanticVersion streamProtoVersion = null;
        @Nullable
        private SemanticVersion softwareVersion = null;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(SemanticVersion addressBookVersion, SemanticVersion streamProtoVersion, SemanticVersion softwareVersion) {
            this.$unknownFields = null;
            this.addressBookVersion = addressBookVersion;
            this.streamProtoVersion = streamProtoVersion;
            this.softwareVersion = softwareVersion;
        }

        public Builder(SemanticVersion addressBookVersion, SemanticVersion streamProtoVersion, SemanticVersion softwareVersion, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.addressBookVersion = addressBookVersion;
            this.streamProtoVersion = streamProtoVersion;
            this.softwareVersion = softwareVersion;
        }

        public BlockNodeVersions build() {
            return new BlockNodeVersions(this.addressBookVersion, this.streamProtoVersion, this.softwareVersion);
        }

        public Builder addressBookVersion(@Nullable SemanticVersion addressBookVersion) {
            this.addressBookVersion = addressBookVersion;
            return this;
        }

        public Builder addressBookVersion(SemanticVersion.Builder builder) {
            this.addressBookVersion = builder.build();
            return this;
        }

        public Builder streamProtoVersion(@Nullable SemanticVersion streamProtoVersion) {
            this.streamProtoVersion = streamProtoVersion;
            return this;
        }

        public Builder streamProtoVersion(SemanticVersion.Builder builder) {
            this.streamProtoVersion = builder.build();
            return this;
        }

        public Builder softwareVersion(@Nullable SemanticVersion softwareVersion) {
            this.softwareVersion = softwareVersion;
            return this;
        }

        public Builder softwareVersion(SemanticVersion.Builder builder) {
            this.softwareVersion = builder.build();
            return this;
        }
    }
}

