/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.virtualmerkle.config;

import com.swirlds.demo.virtualmerkle.config.AssortedTransactionRequestSupplier;
import com.swirlds.demo.virtualmerkle.config.SequentialTransactionRequestSupplier;
import com.swirlds.demo.virtualmerkle.config.TransactionRequestConfig;
import com.swirlds.demo.virtualmerkle.config.VirtualMerkleConfig;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class TransactionRequestSupplierFactory {
    public static final Supplier<TransactionRequestConfig> create(VirtualMerkleConfig virtualMerkleConfig) {
        List<TransactionRequestConfig> requestConfigs = virtualMerkleConfig.getSequential().stream().filter(config -> config.getAmount() > 0L).map(TransactionRequestConfig::new).collect(Collectors.toList());
        if (virtualMerkleConfig.isAssorted()) {
            return new AssortedTransactionRequestSupplier(requestConfigs);
        }
        return new SequentialTransactionRequestSupplier(requestConfigs);
    }
}

