/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform.nft;

import com.swirlds.common.metrics.RunningAverageMetric;
import com.swirlds.common.metrics.SpeedometerMetric;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.platform.system.Platform;

public class NftLedgerStatistics {
    private static final String NFT_CATEGORY = "NFT";
    private static final double DEFAULT_HALF_LIFE = 10.0;
    private static final RunningAverageMetric.Config MINT_TOKEN_MICRO_SEC_CONFIG = new RunningAverageMetric.Config("NFT", "nftMintedTokenMicroSec").withDescription("avg time taken to execute the NftLedger mintToken method (in microseconds)").withHalfLife(10.0);
    private static RunningAverageMetric mintTokenMicroSec;
    private static final RunningAverageMetric.Config TRANSFER_TOKEN_MICRO_SEC_CONFIG;
    private static RunningAverageMetric transferTokenMicroSec;
    private static final RunningAverageMetric.Config BURN_TOKEN_MICRO_SEC_CONFIG;
    private static RunningAverageMetric burnTokenMicroSec;
    private static final SpeedometerMetric.Config MINTED_TOKENS_PER_SECOND_CONFIG;
    private static SpeedometerMetric mintedTokensPerSecond;
    private static final SpeedometerMetric.Config TRANSFERRED_TOKENS_PER_SECOND_CONFIG;
    private static SpeedometerMetric transferredTokensPerSecond;
    private static final SpeedometerMetric.Config BURNED_TOKENS_PER_SECOND_CONFIG;
    private static SpeedometerMetric burnedTokensPerSecond;
    private static boolean registered;

    private NftLedgerStatistics() {
    }

    protected static void recordBurnTokenDuration(long value) {
        if (registered) {
            burnTokenMicroSec.update((double)value);
        }
    }

    protected static void recordMintTokenDuration(long value) {
        if (registered) {
            mintTokenMicroSec.update((double)value);
        }
    }

    protected static void recordTransferTokenDuration(long value) {
        if (registered) {
            transferTokenMicroSec.update((double)value);
        }
    }

    protected static void addBurnTokenOperation() {
        if (registered) {
            burnedTokensPerSecond.update(1.0);
        }
    }

    protected static void addTransferTokenOperation() {
        if (registered) {
            transferredTokensPerSecond.update(1.0);
        }
    }

    protected static void addMintTokenOperation() {
        if (registered) {
            mintedTokensPerSecond.update(1.0);
        }
    }

    public static void register(Platform platform) {
        mintTokenMicroSec = (RunningAverageMetric)platform.getContext().getMetrics().getOrCreate((MetricConfig)MINT_TOKEN_MICRO_SEC_CONFIG);
        transferTokenMicroSec = (RunningAverageMetric)platform.getContext().getMetrics().getOrCreate((MetricConfig)TRANSFER_TOKEN_MICRO_SEC_CONFIG);
        burnTokenMicroSec = (RunningAverageMetric)platform.getContext().getMetrics().getOrCreate((MetricConfig)BURN_TOKEN_MICRO_SEC_CONFIG);
        mintedTokensPerSecond = (SpeedometerMetric)platform.getContext().getMetrics().getOrCreate((MetricConfig)MINTED_TOKENS_PER_SECOND_CONFIG);
        transferredTokensPerSecond = (SpeedometerMetric)platform.getContext().getMetrics().getOrCreate((MetricConfig)TRANSFERRED_TOKENS_PER_SECOND_CONFIG);
        burnedTokensPerSecond = (SpeedometerMetric)platform.getContext().getMetrics().getOrCreate((MetricConfig)BURNED_TOKENS_PER_SECOND_CONFIG);
        registered = true;
    }

    public static void unregister() {
        registered = false;
    }

    static {
        TRANSFER_TOKEN_MICRO_SEC_CONFIG = new RunningAverageMetric.Config(NFT_CATEGORY, "nftTransferTokenMicroSec").withDescription("avg time taken to execute the NftLedger transferToken method (in microseconds)").withHalfLife(10.0);
        BURN_TOKEN_MICRO_SEC_CONFIG = new RunningAverageMetric.Config(NFT_CATEGORY, "nftBurnTokenMicroSec").withDescription("avg time taken to execute the NftLedger burnToken method (in microseconds)").withHalfLife(10.0);
        MINTED_TOKENS_PER_SECOND_CONFIG = new SpeedometerMetric.Config(NFT_CATEGORY, "mintedTokensPerSecond").withDescription("number of NFTs minted per second").withFormat("%,9.6f");
        TRANSFERRED_TOKENS_PER_SECOND_CONFIG = new SpeedometerMetric.Config(NFT_CATEGORY, "transferredTokensPerSecond").withDescription("number of NFTs transferred per second").withFormat("%,9.6f");
        BURNED_TOKENS_PER_SECOND_CONFIG = new SpeedometerMetric.Config(NFT_CATEGORY, "burnedTokensPerSecond").withDescription("number of NFTs burned per second").withFormat("%,9.6f");
    }
}

