/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.crypto.test.fixtures;

import com.goterl.lazysodium.LazySodiumJava;
import com.goterl.lazysodium.SodiumJava;
import com.goterl.lazysodium.interfaces.Sign;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.logging.legacy.LogMarker;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.util.Supplier;
import org.hiero.base.crypto.SignatureType;
import org.hiero.base.crypto.TransactionSignature;

public class SignaturePool {
    static final int SIGNATURE_LENGTH = 64;
    static final int PUBLIC_KEY_LENGTH = 32;
    static final int PRIVATE_KEY_LENGTH = 64;
    static final int SIG_KEY_LENGTH = 96;
    static final Marker LOGM_STARTUP = MarkerManager.getMarker((String)"STARTUP");
    private static final Logger logger = LogManager.getLogger(SignaturePool.class);
    private boolean transactionLogged = false;
    private int poolSize;
    private ArrayList<byte[]> transactions;
    private int transactionSize;
    private boolean signed;
    private Random random;
    private boolean algorithmAvailable;
    private byte[] privateKey;
    private byte[] publicKey;
    private Sign.Native signer;
    private AtomicInteger readPosition;

    public SignaturePool(int poolSize, int transactionSize, boolean signed) {
        if (poolSize < 1) {
            throw new IllegalArgumentException("poolSize");
        }
        if (transactionSize < 1) {
            throw new IllegalArgumentException("transactionSize");
        }
        this.random = new Random();
        this.signed = signed;
        this.transactionSize = transactionSize;
        this.transactions = new ArrayList(poolSize);
        this.poolSize = poolSize;
        this.readPosition = new AtomicInteger(0);
        this.algorithmAvailable = false;
        this.init();
    }

    public TransactionSignature next() {
        int nextIdx = this.readPosition.getAndIncrement();
        if (nextIdx >= this.transactions.size()) {
            nextIdx = 0;
            this.readPosition.set(1);
        }
        byte[] content = this.transactions.get(nextIdx);
        return new TransactionSignature(Bytes.wrap((byte[])content, (int)0, (int)this.transactionSize), Bytes.wrap((byte[])content, (int)this.transactionSize, (int)32), Bytes.wrap((byte[])content, (int)(this.transactionSize + 32), (int)64), SignatureType.ED25519);
    }

    private void init() {
        if (this.signed) {
            this.tryAcquireSignature();
        }
        int bufferSize = this.transactionSize + (this.signed ? 96 : 0);
        for (int i = 0; i < this.poolSize; ++i) {
            byte[] buffer = new byte[bufferSize];
            this.random.nextBytes(buffer);
            if (this.signed) {
                if (!this.algorithmAvailable) {
                    Arrays.fill(buffer, buffer.length - 96, buffer.length, (byte)0);
                } else {
                    this.sign(buffer);
                }
            }
            this.transactions.add(buffer);
        }
    }

    private void sign(byte[] buffer) {
        int dataLength = buffer.length - 96;
        try {
            int offset = dataLength;
            byte[] data = new byte[dataLength];
            byte[] sig = new byte[64];
            System.arraycopy(buffer, 0, data, 0, dataLength);
            System.arraycopy(this.publicKey, 0, buffer, offset, this.publicKey.length);
            offset += this.publicKey.length;
            if (!this.signer.cryptoSignDetached(sig, data, (long)data.length, this.privateKey)) {
                throw new SignatureException();
            }
            if (!this.transactionLogged) {
                logger.trace(LOGM_STARTUP, "StatsSigningDemo: Signed Message { publicKey = '{}', privateKey ='{}', signature = '{}', message = '{}' }", (Object)this.hex(this.publicKey), (Object)this.hex(this.privateKey), (Object)this.hex(sig), (Object)this.hex(data));
                this.transactionLogged = true;
            }
            System.arraycopy(sig, 0, buffer, offset, sig.length);
        }
        catch (Exception ex) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Adv Crypto Subsystem: Failed to sign transaction", (Throwable)ex);
        }
    }

    private void tryAcquireSignature() {
        try {
            SodiumJava sodium = new SodiumJava();
            this.signer = new LazySodiumJava(sodium);
            this.publicKey = new byte[32];
            this.privateKey = new byte[64];
            this.algorithmAvailable = this.signer.cryptoSignKeypair(this.publicKey, this.privateKey);
            logger.trace(LOGM_STARTUP, "StatsSigningDemo: Public Key -> hex('{}')", new Supplier[]{() -> this.hex(this.publicKey)});
        }
        catch (Exception ex) {
            this.algorithmAvailable = false;
        }
    }

    private String hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        sb.append("0x");
        for (byte b : bytes) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }
}

