/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.consensus.framework.validation;

import com.hedera.hapi.platform.state.MinimumJudgeInfo;
import com.swirlds.platform.test.fixtures.consensus.framework.validation.ConsensusRoundConsistencyValidation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.ConsensusRound;

public enum RoundInternalConsistencyValidation implements ConsensusRoundConsistencyValidation
{
    INSTANCE;


    @Override
    public void validate(@NonNull List<ConsensusRound> rounds) {
        for (ConsensusRound round : rounds) {
            MinimumJudgeInfo minimumJudgeInfo = (MinimumJudgeInfo)round.getSnapshot().minimumJudgeInfoList().getLast();
            ((AbstractLongAssert)Assertions.assertThat((long)round.getRoundNum()).withFailMessage(String.format("the last threshold should be equal for the current round %d", round.getRoundNum()), new Object[0])).isEqualTo(minimumJudgeInfo.round());
            for (PlatformEvent event : round.getConsensusEvents()) {
                Assertions.assertThat((Object)event.getConsensusData()).isNotNull();
            }
        }
    }
}

