/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.freeze.codec;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.freeze.FreezeTransactionBody;
import com.hedera.hapi.node.freeze.FreezeType;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class FreezeTransactionBodyJsonCodec
implements JsonCodec<FreezeTransactionBody> {
    @NonNull
    public FreezeTransactionBody parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            int temp_startHour = 0;
            int temp_startMin = 0;
            int temp_endHour = 0;
            int temp_endMin = 0;
            FileID temp_update_file = null;
            Bytes temp_file_hash = Bytes.EMPTY;
            Timestamp temp_start_time = null;
            FreezeType temp_freeze_type = FreezeType.fromProtobufOrdinal(0);
            block22: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "startHour": {
                        temp_startHour = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block22;
                    }
                    case "startMin": {
                        temp_startMin = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block22;
                    }
                    case "endHour": {
                        temp_endHour = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block22;
                    }
                    case "endMin": {
                        temp_endMin = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block22;
                    }
                    case "updateFile": {
                        temp_update_file = (FileID)FileID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block22;
                    }
                    case "fileHash": {
                        temp_file_hash = Bytes.fromBase64((String)JsonTools.checkSize((String)"file_hash", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block22;
                    }
                    case "startTime": {
                        temp_start_time = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block22;
                    }
                    case "freezeType": {
                        temp_freeze_type = FreezeType.fromString(kvPair.value().STRING().getText());
                        continue block22;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new FreezeTransactionBody(temp_startHour, temp_startMin, temp_endHour, temp_endMin, temp_update_file, temp_file_hash, temp_start_time, temp_freeze_type);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull FreezeTransactionBody data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.startHour() != 0) {
            fieldLines.add(JsonTools.field((String)"startHour", (int)data.startHour()));
        }
        if (data.startMin() != 0) {
            fieldLines.add(JsonTools.field((String)"startMin", (int)data.startMin()));
        }
        if (data.endHour() != 0) {
            fieldLines.add(JsonTools.field((String)"endHour", (int)data.endHour()));
        }
        if (data.endMin() != 0) {
            fieldLines.add(JsonTools.field((String)"endMin", (int)data.endMin()));
        }
        if (data.updateFile() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"updateFile", FileID.JSON, (Object)data.updateFile()));
        }
        if (data.fileHash() != Bytes.EMPTY && data.fileHash() != null && data.fileHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"fileHash", (Bytes)data.fileHash()));
        }
        if (data.startTime() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"startTime", Timestamp.JSON, (Object)data.startTime()));
        }
        if (data.freezeType() != FreezeType.fromProtobufOrdinal(0)) {
            fieldLines.add(JsonTools.field((String)"freezeType", (String)data.freezeType().protoName()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

