/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.blockrecords;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.blockrecords.codec.BlockInfoJsonCodec;
import com.hedera.hapi.node.state.blockrecords.codec.BlockInfoProtoCodec;
import com.hedera.hapi.node.state.blockrecords.schema.BlockInfoSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class BlockInfo {
    public static final Codec<BlockInfo> PROTOBUF = new BlockInfoProtoCodec();
    public static final JsonCodec<BlockInfo> JSON = new BlockInfoJsonCodec();
    public static final BlockInfo DEFAULT = BlockInfo.newBuilder().build();
    private final long lastBlockNumber;
    @Nullable
    private final Timestamp firstConsTimeOfLastBlock;
    @NonNull
    private final Bytes blockHashes;
    @Nullable
    private final Timestamp consTimeOfLastHandledTxn;
    private final boolean migrationRecordsStreamed;
    @Nullable
    private final Timestamp firstConsTimeOfCurrentBlock;
    @Nullable
    private final Timestamp lastUsedConsTime;
    @Nullable
    private final Timestamp lastIntervalProcessTime;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public BlockInfo(long lastBlockNumber, Timestamp firstConsTimeOfLastBlock, Bytes blockHashes, Timestamp consTimeOfLastHandledTxn, boolean migrationRecordsStreamed, Timestamp firstConsTimeOfCurrentBlock, Timestamp lastUsedConsTime, Timestamp lastIntervalProcessTime) {
        this.$unknownFields = null;
        this.lastBlockNumber = lastBlockNumber;
        this.firstConsTimeOfLastBlock = firstConsTimeOfLastBlock;
        this.blockHashes = blockHashes != null ? blockHashes : Bytes.EMPTY;
        this.consTimeOfLastHandledTxn = consTimeOfLastHandledTxn;
        this.migrationRecordsStreamed = migrationRecordsStreamed;
        this.firstConsTimeOfCurrentBlock = firstConsTimeOfCurrentBlock;
        this.lastUsedConsTime = lastUsedConsTime;
        this.lastIntervalProcessTime = lastIntervalProcessTime;
    }

    public BlockInfo(long lastBlockNumber, Timestamp firstConsTimeOfLastBlock, Bytes blockHashes, Timestamp consTimeOfLastHandledTxn, boolean migrationRecordsStreamed, Timestamp firstConsTimeOfCurrentBlock, Timestamp lastUsedConsTime, Timestamp lastIntervalProcessTime, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.lastBlockNumber = lastBlockNumber;
        this.firstConsTimeOfLastBlock = firstConsTimeOfLastBlock;
        this.blockHashes = blockHashes != null ? blockHashes : Bytes.EMPTY;
        this.consTimeOfLastHandledTxn = consTimeOfLastHandledTxn;
        this.migrationRecordsStreamed = migrationRecordsStreamed;
        this.firstConsTimeOfCurrentBlock = firstConsTimeOfCurrentBlock;
        this.lastUsedConsTime = lastUsedConsTime;
        this.lastIntervalProcessTime = lastIntervalProcessTime;
    }

    public long lastBlockNumber() {
        return this.lastBlockNumber;
    }

    public Timestamp firstConsTimeOfLastBlock() {
        return this.firstConsTimeOfLastBlock;
    }

    public Bytes blockHashes() {
        return this.blockHashes;
    }

    public Timestamp consTimeOfLastHandledTxn() {
        return this.consTimeOfLastHandledTxn;
    }

    public boolean migrationRecordsStreamed() {
        return this.migrationRecordsStreamed;
    }

    public Timestamp firstConsTimeOfCurrentBlock() {
        return this.firstConsTimeOfCurrentBlock;
    }

    public Timestamp lastUsedConsTime() {
        return this.lastUsedConsTime;
    }

    public Timestamp lastIntervalProcessTime() {
        return this.lastIntervalProcessTime;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)BlockInfoSchema.LAST_BLOCK_NUMBER, (long)this.lastBlockNumber, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)BlockInfoSchema.FIRST_CONS_TIME_OF_LAST_BLOCK, (Object)this.firstConsTimeOfLastBlock, Timestamp.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)BlockInfoSchema.BLOCK_HASHES, (RandomAccessData)this.blockHashes, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)BlockInfoSchema.CONS_TIME_OF_LAST_HANDLED_TXN, (Object)this.consTimeOfLastHandledTxn, Timestamp.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)BlockInfoSchema.MIGRATION_RECORDS_STREAMED, (boolean)this.migrationRecordsStreamed, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)BlockInfoSchema.FIRST_CONS_TIME_OF_CURRENT_BLOCK, (Object)this.firstConsTimeOfCurrentBlock, Timestamp.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)BlockInfoSchema.LAST_USED_CONS_TIME, (Object)this.lastUsedConsTime, Timestamp.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)BlockInfoSchema.LAST_INTERVAL_PROCESS_TIME, (Object)this.lastIntervalProcessTime, Timestamp.PROTOBUF);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.lastBlockNumber != BlockInfo.DEFAULT.lastBlockNumber) {
                result = 31 * result + Long.hashCode(this.lastBlockNumber);
            }
            if (this.firstConsTimeOfLastBlock != null && !this.firstConsTimeOfLastBlock.equals(BlockInfo.DEFAULT.firstConsTimeOfLastBlock)) {
                result = 31 * result + this.firstConsTimeOfLastBlock.hashCode();
            }
            if (this.blockHashes != null && !this.blockHashes.equals((Object)BlockInfo.DEFAULT.blockHashes)) {
                result = 31 * result + this.blockHashes.hashCode();
            }
            if (this.consTimeOfLastHandledTxn != null && !this.consTimeOfLastHandledTxn.equals(BlockInfo.DEFAULT.consTimeOfLastHandledTxn)) {
                result = 31 * result + this.consTimeOfLastHandledTxn.hashCode();
            }
            if (this.migrationRecordsStreamed != BlockInfo.DEFAULT.migrationRecordsStreamed) {
                result = 31 * result + Boolean.hashCode(this.migrationRecordsStreamed);
            }
            if (this.firstConsTimeOfCurrentBlock != null && !this.firstConsTimeOfCurrentBlock.equals(BlockInfo.DEFAULT.firstConsTimeOfCurrentBlock)) {
                result = 31 * result + this.firstConsTimeOfCurrentBlock.hashCode();
            }
            if (this.lastUsedConsTime != null && !this.lastUsedConsTime.equals(BlockInfo.DEFAULT.lastUsedConsTime)) {
                result = 31 * result + this.lastUsedConsTime.hashCode();
            }
            if (this.lastIntervalProcessTime != null && !this.lastIntervalProcessTime.equals(BlockInfo.DEFAULT.lastIntervalProcessTime)) {
                result = 31 * result + this.lastIntervalProcessTime.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        BlockInfo thatObj = (BlockInfo)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.lastBlockNumber != thatObj.lastBlockNumber) {
            return false;
        }
        if (this.firstConsTimeOfLastBlock == null && thatObj.firstConsTimeOfLastBlock != null) {
            return false;
        }
        if (this.firstConsTimeOfLastBlock != null && !this.firstConsTimeOfLastBlock.equals(thatObj.firstConsTimeOfLastBlock)) {
            return false;
        }
        if (this.blockHashes == null && thatObj.blockHashes != null) {
            return false;
        }
        if (this.blockHashes != null && !this.blockHashes.equals((Object)thatObj.blockHashes)) {
            return false;
        }
        if (this.consTimeOfLastHandledTxn == null && thatObj.consTimeOfLastHandledTxn != null) {
            return false;
        }
        if (this.consTimeOfLastHandledTxn != null && !this.consTimeOfLastHandledTxn.equals(thatObj.consTimeOfLastHandledTxn)) {
            return false;
        }
        if (this.migrationRecordsStreamed != thatObj.migrationRecordsStreamed) {
            return false;
        }
        if (this.firstConsTimeOfCurrentBlock == null && thatObj.firstConsTimeOfCurrentBlock != null) {
            return false;
        }
        if (this.firstConsTimeOfCurrentBlock != null && !this.firstConsTimeOfCurrentBlock.equals(thatObj.firstConsTimeOfCurrentBlock)) {
            return false;
        }
        if (this.lastUsedConsTime == null && thatObj.lastUsedConsTime != null) {
            return false;
        }
        if (this.lastUsedConsTime != null && !this.lastUsedConsTime.equals(thatObj.lastUsedConsTime)) {
            return false;
        }
        if (this.lastIntervalProcessTime == null && thatObj.lastIntervalProcessTime != null) {
            return false;
        }
        if (this.lastIntervalProcessTime != null && !this.lastIntervalProcessTime.equals(thatObj.lastIntervalProcessTime)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "BlockInfo[lastBlockNumber=" + this.lastBlockNumber + ", firstConsTimeOfLastBlock=" + String.valueOf(this.firstConsTimeOfLastBlock) + ", blockHashes=" + String.valueOf(this.blockHashes) + ", consTimeOfLastHandledTxn=" + String.valueOf(this.consTimeOfLastHandledTxn) + ", migrationRecordsStreamed=" + this.migrationRecordsStreamed + ", firstConsTimeOfCurrentBlock=" + String.valueOf(this.firstConsTimeOfCurrentBlock) + ", lastUsedConsTime=" + String.valueOf(this.lastUsedConsTime) + ", lastIntervalProcessTime=" + String.valueOf(this.lastIntervalProcessTime) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasFirstConsTimeOfLastBlock() {
        return this.firstConsTimeOfLastBlock != null;
    }

    public Timestamp firstConsTimeOfLastBlockOrElse(@NonNull Timestamp defaultValue) {
        return this.hasFirstConsTimeOfLastBlock() ? this.firstConsTimeOfLastBlock : defaultValue;
    }

    @NonNull
    public Timestamp firstConsTimeOfLastBlockOrThrow() {
        return Objects.requireNonNull(this.firstConsTimeOfLastBlock, "Field firstConsTimeOfLastBlock is null");
    }

    public void ifFirstConsTimeOfLastBlock(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasFirstConsTimeOfLastBlock()) {
            ifPresent.accept(this.firstConsTimeOfLastBlock);
        }
    }

    public boolean hasConsTimeOfLastHandledTxn() {
        return this.consTimeOfLastHandledTxn != null;
    }

    public Timestamp consTimeOfLastHandledTxnOrElse(@NonNull Timestamp defaultValue) {
        return this.hasConsTimeOfLastHandledTxn() ? this.consTimeOfLastHandledTxn : defaultValue;
    }

    @NonNull
    public Timestamp consTimeOfLastHandledTxnOrThrow() {
        return Objects.requireNonNull(this.consTimeOfLastHandledTxn, "Field consTimeOfLastHandledTxn is null");
    }

    public void ifConsTimeOfLastHandledTxn(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasConsTimeOfLastHandledTxn()) {
            ifPresent.accept(this.consTimeOfLastHandledTxn);
        }
    }

    public boolean hasFirstConsTimeOfCurrentBlock() {
        return this.firstConsTimeOfCurrentBlock != null;
    }

    public Timestamp firstConsTimeOfCurrentBlockOrElse(@NonNull Timestamp defaultValue) {
        return this.hasFirstConsTimeOfCurrentBlock() ? this.firstConsTimeOfCurrentBlock : defaultValue;
    }

    @NonNull
    public Timestamp firstConsTimeOfCurrentBlockOrThrow() {
        return Objects.requireNonNull(this.firstConsTimeOfCurrentBlock, "Field firstConsTimeOfCurrentBlock is null");
    }

    public void ifFirstConsTimeOfCurrentBlock(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasFirstConsTimeOfCurrentBlock()) {
            ifPresent.accept(this.firstConsTimeOfCurrentBlock);
        }
    }

    public boolean hasLastUsedConsTime() {
        return this.lastUsedConsTime != null;
    }

    public Timestamp lastUsedConsTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasLastUsedConsTime() ? this.lastUsedConsTime : defaultValue;
    }

    @NonNull
    public Timestamp lastUsedConsTimeOrThrow() {
        return Objects.requireNonNull(this.lastUsedConsTime, "Field lastUsedConsTime is null");
    }

    public void ifLastUsedConsTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasLastUsedConsTime()) {
            ifPresent.accept(this.lastUsedConsTime);
        }
    }

    public boolean hasLastIntervalProcessTime() {
        return this.lastIntervalProcessTime != null;
    }

    public Timestamp lastIntervalProcessTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasLastIntervalProcessTime() ? this.lastIntervalProcessTime : defaultValue;
    }

    @NonNull
    public Timestamp lastIntervalProcessTimeOrThrow() {
        return Objects.requireNonNull(this.lastIntervalProcessTime, "Field lastIntervalProcessTime is null");
    }

    public void ifLastIntervalProcessTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasLastIntervalProcessTime()) {
            ifPresent.accept(this.lastIntervalProcessTime);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.lastBlockNumber, this.firstConsTimeOfLastBlock, this.blockHashes, this.consTimeOfLastHandledTxn, this.migrationRecordsStreamed, this.firstConsTimeOfCurrentBlock, this.lastUsedConsTime, this.lastIntervalProcessTime, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private long lastBlockNumber = 0L;
        @Nullable
        private Timestamp firstConsTimeOfLastBlock = null;
        @NonNull
        private Bytes blockHashes = Bytes.EMPTY;
        @Nullable
        private Timestamp consTimeOfLastHandledTxn = null;
        private boolean migrationRecordsStreamed = false;
        @Nullable
        private Timestamp firstConsTimeOfCurrentBlock = null;
        @Nullable
        private Timestamp lastUsedConsTime = null;
        @Nullable
        private Timestamp lastIntervalProcessTime = null;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(long lastBlockNumber, Timestamp firstConsTimeOfLastBlock, Bytes blockHashes, Timestamp consTimeOfLastHandledTxn, boolean migrationRecordsStreamed, Timestamp firstConsTimeOfCurrentBlock, Timestamp lastUsedConsTime, Timestamp lastIntervalProcessTime) {
            this.$unknownFields = null;
            this.lastBlockNumber = lastBlockNumber;
            this.firstConsTimeOfLastBlock = firstConsTimeOfLastBlock;
            this.blockHashes = blockHashes != null ? blockHashes : Bytes.EMPTY;
            this.consTimeOfLastHandledTxn = consTimeOfLastHandledTxn;
            this.migrationRecordsStreamed = migrationRecordsStreamed;
            this.firstConsTimeOfCurrentBlock = firstConsTimeOfCurrentBlock;
            this.lastUsedConsTime = lastUsedConsTime;
            this.lastIntervalProcessTime = lastIntervalProcessTime;
        }

        public Builder(long lastBlockNumber, Timestamp firstConsTimeOfLastBlock, Bytes blockHashes, Timestamp consTimeOfLastHandledTxn, boolean migrationRecordsStreamed, Timestamp firstConsTimeOfCurrentBlock, Timestamp lastUsedConsTime, Timestamp lastIntervalProcessTime, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.lastBlockNumber = lastBlockNumber;
            this.firstConsTimeOfLastBlock = firstConsTimeOfLastBlock;
            this.blockHashes = blockHashes != null ? blockHashes : Bytes.EMPTY;
            this.consTimeOfLastHandledTxn = consTimeOfLastHandledTxn;
            this.migrationRecordsStreamed = migrationRecordsStreamed;
            this.firstConsTimeOfCurrentBlock = firstConsTimeOfCurrentBlock;
            this.lastUsedConsTime = lastUsedConsTime;
            this.lastIntervalProcessTime = lastIntervalProcessTime;
        }

        public BlockInfo build() {
            return new BlockInfo(this.lastBlockNumber, this.firstConsTimeOfLastBlock, this.blockHashes, this.consTimeOfLastHandledTxn, this.migrationRecordsStreamed, this.firstConsTimeOfCurrentBlock, this.lastUsedConsTime, this.lastIntervalProcessTime);
        }

        public Builder lastBlockNumber(long lastBlockNumber) {
            this.lastBlockNumber = lastBlockNumber;
            return this;
        }

        public Builder firstConsTimeOfLastBlock(@Nullable Timestamp firstConsTimeOfLastBlock) {
            this.firstConsTimeOfLastBlock = firstConsTimeOfLastBlock;
            return this;
        }

        public Builder firstConsTimeOfLastBlock(Timestamp.Builder builder) {
            this.firstConsTimeOfLastBlock = builder.build();
            return this;
        }

        public Builder blockHashes(@NonNull Bytes blockHashes) {
            this.blockHashes = blockHashes != null ? blockHashes : Bytes.EMPTY;
            return this;
        }

        public Builder consTimeOfLastHandledTxn(@Nullable Timestamp consTimeOfLastHandledTxn) {
            this.consTimeOfLastHandledTxn = consTimeOfLastHandledTxn;
            return this;
        }

        public Builder consTimeOfLastHandledTxn(Timestamp.Builder builder) {
            this.consTimeOfLastHandledTxn = builder.build();
            return this;
        }

        public Builder migrationRecordsStreamed(boolean migrationRecordsStreamed) {
            this.migrationRecordsStreamed = migrationRecordsStreamed;
            return this;
        }

        public Builder firstConsTimeOfCurrentBlock(@Nullable Timestamp firstConsTimeOfCurrentBlock) {
            this.firstConsTimeOfCurrentBlock = firstConsTimeOfCurrentBlock;
            return this;
        }

        public Builder firstConsTimeOfCurrentBlock(Timestamp.Builder builder) {
            this.firstConsTimeOfCurrentBlock = builder.build();
            return this;
        }

        public Builder lastUsedConsTime(@Nullable Timestamp lastUsedConsTime) {
            this.lastUsedConsTime = lastUsedConsTime;
            return this;
        }

        public Builder lastUsedConsTime(Timestamp.Builder builder) {
            this.lastUsedConsTime = builder.build();
            return this;
        }

        public Builder lastIntervalProcessTime(@Nullable Timestamp lastIntervalProcessTime) {
            this.lastIntervalProcessTime = lastIntervalProcessTime;
            return this;
        }

        public Builder lastIntervalProcessTime(Timestamp.Builder builder) {
            this.lastIntervalProcessTime = builder.build();
            return this;
        }
    }
}

