/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.history.codec;

import com.hedera.hapi.node.state.history.History;
import com.hedera.hapi.node.state.history.HistoryProof;
import com.hedera.hapi.node.state.history.ProofKey;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class HistoryProofJsonCodec
implements JsonCodec<HistoryProof> {
    @NonNull
    public HistoryProof parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            Bytes temp_source_address_book_hash = Bytes.EMPTY;
            List temp_target_proof_keys = Collections.emptyList();
            History temp_target_history = null;
            Bytes temp_proof = Bytes.EMPTY;
            block14: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "sourceAddressBookHash": {
                        temp_source_address_book_hash = Bytes.fromBase64((String)JsonTools.checkSize((String)"source_address_book_hash", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block14;
                    }
                    case "targetProofKeys": {
                        temp_target_proof_keys = JsonTools.parseObjArray((List)JsonTools.checkSize((String)"target_proof_keys", (List)kvPair.value().arr().value(), (int)maxSize), ProofKey.JSON, (int)(maxDepth - 1), (int)maxSize);
                        continue block14;
                    }
                    case "targetHistory": {
                        temp_target_history = (History)History.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block14;
                    }
                    case "proof": {
                        temp_proof = Bytes.fromBase64((String)JsonTools.checkSize((String)"proof", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block14;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new HistoryProof(temp_source_address_book_hash, temp_target_proof_keys, temp_target_history, temp_proof);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull HistoryProof data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.sourceAddressBookHash() != Bytes.EMPTY && data.sourceAddressBookHash() != null && data.sourceAddressBookHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"sourceAddressBookHash", (Bytes)data.sourceAddressBookHash()));
        }
        if (!data.targetProofKeys().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"targetProofKeys", ProofKey.JSON, data.targetProofKeys()));
        }
        if (data.targetHistory() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"targetHistory", History.JSON, (Object)data.targetHistory()));
        }
        if (data.proof() != Bytes.EMPTY && data.proof() != null && data.proof().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"proof", (Bytes)data.proof()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

