/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime.grpc;

import com.hedera.pbj.runtime.grpc.Pipeline;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.Flow;

public final class Pipelines {
    private Pipelines() {
    }

    public static Pipeline<? super Bytes> noop() {
        return new Pipeline<Bytes>(){
            private Flow.Subscription subscription;

            @Override
            public void clientEndStreamReceived() {
            }

            @Override
            public void onSubscribe(@NonNull Flow.Subscription subscription) {
                this.subscription = Objects.requireNonNull(subscription);
                subscription.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(@NonNull Bytes item) {
            }

            @Override
            public void onError(@NonNull Throwable throwable) {
                this.subscription.cancel();
            }

            @Override
            public void onComplete() {
            }
        };
    }

    public static <T, R> UnaryBuilder<T, R> unary() {
        return new UnaryBuilderImpl();
    }

    public static <T, R> BidiStreamingBuilder<T, R> bidiStreaming() {
        return new BidiStreamingBuilderImpl();
    }

    public static <T, R> ClientStreamingBuilder<T, R> clientStreaming() {
        return new ClientStreamingBuilderImpl();
    }

    public static <T, R> ServerStreamingBuilder<T, R> serverStreaming() {
        return new ServerStreamingBuilderImpl();
    }

    private static final class UnaryBuilderImpl<T, R>
    extends PipelineBuilderImpl<T, R>
    implements UnaryBuilder<T, R> {
        private ExceptionalFunction<T, R> method;

        private UnaryBuilderImpl() {
        }

        @Override
        @NonNull
        public UnaryBuilder<T, R> mapRequest(@NonNull ExceptionalFunction<Bytes, T> mapper) {
            this.requestMapper = Objects.requireNonNull(mapper);
            return this;
        }

        @Override
        @NonNull
        public UnaryBuilder<T, R> method(@NonNull ExceptionalFunction<T, R> method) {
            this.method = Objects.requireNonNull(method);
            return this;
        }

        @Override
        @NonNull
        public UnaryBuilder<T, R> mapResponse(@NonNull ExceptionalFunction<R, Bytes> mapper) {
            this.responseMapper = Objects.requireNonNull(mapper);
            return this;
        }

        @Override
        @NonNull
        public UnaryBuilder<T, R> respondTo(@NonNull Pipeline<? super Bytes> replies) {
            this.replies = Objects.requireNonNull(replies);
            return this;
        }

        @Override
        @NonNull
        public Pipeline<? super Bytes> build() {
            this.validateParams();
            if (this.method == null) {
                throw new IllegalStateException("The method must be specified.");
            }
            this.replies.onSubscribe(this);
            return this;
        }

        @Override
        public void onNext(@NonNull Bytes message) {
            if (this.completed) {
                this.replies.onError(new IllegalStateException("Unary method already called."));
                return;
            }
            try {
                Object request = this.requestMapper.apply(message);
                R reply = this.method.apply(request);
                Bytes replyBytes = (Bytes)this.responseMapper.apply(reply);
                this.replies.onNext(replyBytes);
                this.onComplete();
            }
            catch (RuntimeException e) {
                this.replies.onError(e);
                throw e;
            }
            catch (Exception e) {
                this.replies.onError(e);
                throw new RuntimeException(e);
            }
        }

        @Override
        public void clientEndStreamReceived() {
        }
    }

    private static final class BidiStreamingBuilderImpl<T, R>
    extends PipelineBuilderImpl<T, R>
    implements BidiStreamingBuilder<T, R> {
        private BidiStreamingMethod<T, R> method;
        private Pipeline<? super T> incoming;

        private BidiStreamingBuilderImpl() {
        }

        @Override
        @NonNull
        public BidiStreamingBuilderImpl<T, R> mapRequest(@NonNull ExceptionalFunction<Bytes, T> mapper) {
            this.requestMapper = mapper;
            return this;
        }

        @Override
        @NonNull
        public BidiStreamingBuilderImpl<T, R> method(@NonNull BidiStreamingMethod<T, R> method) {
            this.method = method;
            return this;
        }

        @Override
        @NonNull
        public BidiStreamingBuilderImpl<T, R> mapResponse(@NonNull ExceptionalFunction<R, Bytes> mapper) {
            this.responseMapper = mapper;
            return this;
        }

        @Override
        @NonNull
        public BidiStreamingBuilderImpl<T, R> respondTo(@NonNull Pipeline<? super Bytes> replies) {
            this.replies = replies;
            return this;
        }

        @Override
        @NonNull
        public Pipeline<? super Bytes> build() {
            this.validateParams();
            if (this.method == null) {
                throw new IllegalStateException("The method must be specified.");
            }
            this.replies.onSubscribe(this);
            MapSubscriber<Object, Bytes> responseConverter = new MapSubscriber<Object, Bytes>(this.replies, item -> (Bytes)this.responseMapper.apply(item));
            try {
                this.incoming = (Pipeline)this.method.apply(responseConverter);
            }
            catch (Exception e) {
                this.replies.onError(e);
            }
            return this;
        }

        @Override
        public void onNext(@NonNull Bytes message) {
            if (this.completed) {
                this.replies.onError(new IllegalStateException("BidiStreaming method already called."));
                return;
            }
            try {
                Object request = this.requestMapper.apply(message);
                this.incoming.onNext(request);
            }
            catch (RuntimeException e) {
                this.replies.onError(e);
                throw e;
            }
            catch (Exception e) {
                this.replies.onError(e);
                throw new RuntimeException(e);
            }
        }

        @Override
        public void onComplete() {
            this.incoming.onComplete();
            super.onComplete();
        }

        @Override
        public void clientEndStreamReceived() {
            this.onComplete();
        }
    }

    private static final class ClientStreamingBuilderImpl<T, R>
    extends PipelineBuilderImpl<T, R>
    implements ClientStreamingBuilder<T, R> {
        private ClientStreamingMethod<T, R> method;
        private Pipeline<? super T> incoming;

        private ClientStreamingBuilderImpl() {
        }

        @Override
        @NonNull
        public ClientStreamingBuilderImpl<T, R> mapRequest(@NonNull ExceptionalFunction<Bytes, T> mapper) {
            this.requestMapper = mapper;
            return this;
        }

        @Override
        @NonNull
        public ClientStreamingBuilderImpl<T, R> method(@NonNull ClientStreamingMethod<T, R> method) {
            this.method = method;
            return this;
        }

        @Override
        @NonNull
        public ClientStreamingBuilderImpl<T, R> mapResponse(@NonNull ExceptionalFunction<R, Bytes> mapper) {
            this.responseMapper = mapper;
            return this;
        }

        @Override
        @NonNull
        public ClientStreamingBuilderImpl<T, R> respondTo(@NonNull Pipeline<? super Bytes> replies) {
            this.replies = replies;
            return this;
        }

        @Override
        @NonNull
        public Pipeline<? super Bytes> build() {
            this.validateParams();
            if (this.method == null) {
                throw new IllegalStateException("The method must be specified.");
            }
            this.replies.onSubscribe(this);
            MapSubscriber<Object, Bytes> responseConverter = new MapSubscriber<Object, Bytes>(this.replies, item -> (Bytes)this.responseMapper.apply(item));
            try {
                this.incoming = (Pipeline)this.method.apply(responseConverter);
            }
            catch (Exception e) {
                this.replies.onError(e);
            }
            return this;
        }

        @Override
        public void onNext(@NonNull Bytes message) {
            if (this.completed) {
                this.replies.onError(new IllegalStateException("ClientStreaming method already called."));
                return;
            }
            try {
                Object request = this.requestMapper.apply(message);
                this.incoming.onNext(request);
            }
            catch (RuntimeException e) {
                this.replies.onError(e);
                throw e;
            }
            catch (Exception e) {
                this.replies.onError(e);
                throw new RuntimeException(e);
            }
        }

        @Override
        public void onComplete() {
            this.incoming.onComplete();
            super.onComplete();
        }

        @Override
        public void clientEndStreamReceived() {
            this.onComplete();
        }
    }

    private static final class ServerStreamingBuilderImpl<T, R>
    extends PipelineBuilderImpl<T, R>
    implements ServerStreamingBuilder<T, R> {
        private ServerStreamingMethod<T, R> method;
        private Pipeline<? super R> responseConverter;

        private ServerStreamingBuilderImpl() {
        }

        @Override
        @NonNull
        public ServerStreamingBuilderImpl<T, R> mapRequest(@NonNull ExceptionalFunction<Bytes, T> mapper) {
            this.requestMapper = mapper;
            return this;
        }

        @Override
        @NonNull
        public ServerStreamingBuilderImpl<T, R> method(@NonNull ServerStreamingMethod<T, R> method) {
            this.method = method;
            return this;
        }

        @Override
        @NonNull
        public ServerStreamingBuilderImpl<T, R> mapResponse(@NonNull ExceptionalFunction<R, Bytes> mapper) {
            this.responseMapper = mapper;
            return this;
        }

        @Override
        @NonNull
        public ServerStreamingBuilderImpl<T, R> respondTo(@NonNull Pipeline<? super Bytes> replies) {
            this.replies = replies;
            return this;
        }

        @Override
        @NonNull
        public Pipeline<? super Bytes> build() {
            this.validateParams();
            if (this.method == null) {
                throw new IllegalStateException("The method must be specified.");
            }
            this.responseConverter = new MapSubscriber<Object, Bytes>(this.replies, item -> (Bytes)this.responseMapper.apply(item));
            this.responseConverter.onSubscribe(this);
            return this;
        }

        @Override
        public void onNext(@NonNull Bytes message) {
            if (this.completed) {
                this.replies.onError(new IllegalStateException("ServerStreaming method already called."));
                return;
            }
            try {
                Object request = this.requestMapper.apply(message);
                this.method.apply(request, this.responseConverter);
            }
            catch (RuntimeException e) {
                this.replies.onError(e);
                throw e;
            }
            catch (Exception e) {
                this.replies.onError(e);
                throw new RuntimeException(e);
            }
        }

        @Override
        public void clientEndStreamReceived() {
        }
    }

    private record MapSubscriber<T, R>(Pipeline<? super R> next, ExceptionalFunction<T, R> mapper) implements Pipeline<T>,
    Flow.Subscription
    {
        private MapSubscriber(Pipeline<? super R> next, ExceptionalFunction<T, R> mapper) {
            next.onSubscribe(this);
            this.next = next;
            this.mapper = mapper;
        }

        @Override
        public void request(long n) {
        }

        @Override
        public void cancel() {
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            subscription.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(T item) {
            try {
                R r = this.mapper.apply(item);
                this.next.onNext(r);
            }
            catch (RuntimeException e) {
                this.next.onError(e);
                throw e;
            }
            catch (Throwable t) {
                this.next.onError(t);
                throw new RuntimeException(t);
            }
        }

        @Override
        public void onError(Throwable throwable) {
            this.next.onError(throwable);
        }

        @Override
        public void onComplete() {
            this.next.onComplete();
        }
    }

    private static abstract class PipelineBuilderImpl<T, R>
    implements Pipeline<Bytes>,
    Flow.Subscription {
        protected ExceptionalFunction<Bytes, T> requestMapper;
        protected ExceptionalFunction<R, Bytes> responseMapper;
        protected Pipeline<? super Bytes> replies;
        private Flow.Subscription sourceSubscription;
        protected boolean completed = false;

        private PipelineBuilderImpl() {
        }

        @Override
        public void request(long n) {
        }

        @Override
        public void cancel() {
            this.sourceSubscription.cancel();
        }

        @Override
        public void onSubscribe(@NonNull Flow.Subscription subscription) {
            this.sourceSubscription = Objects.requireNonNull(subscription);
            subscription.request(Long.MAX_VALUE);
        }

        @Override
        public void onError(@NonNull Throwable throwable) {
            if (this.replies != null) {
                this.replies.onError(throwable);
            }
        }

        @Override
        public void onComplete() {
            this.completed = true;
            if (this.replies != null) {
                this.replies.onComplete();
            }
        }

        protected void validateParams() {
            if (this.replies == null) {
                throw new IllegalStateException("The replies subscriber must be specified.");
            }
            if (this.requestMapper == null) {
                throw new IllegalStateException("The request mapper must be specified.");
            }
            if (this.responseMapper == null) {
                throw new IllegalStateException("The response mapper must be specified.");
            }
        }
    }

    public static interface BidiStreamingMethod<T, R>
    extends ExceptionalFunction<Pipeline<? super R>, Pipeline<? super T>> {
    }

    public static interface ServerStreamingMethod<T, R> {
        public void apply(@NonNull T var1, @NonNull Pipeline<? super R> var2) throws Exception;
    }

    @FunctionalInterface
    public static interface ClientStreamingMethod<T, R>
    extends ExceptionalFunction<Pipeline<? super R>, Pipeline<? super T>> {
    }

    @FunctionalInterface
    public static interface ExceptionalFunction<T, R> {
        @NonNull
        public R apply(@NonNull T var1) throws Exception;
    }

    public static interface ServerStreamingBuilder<T, R> {
        @NonNull
        public ServerStreamingBuilder<T, R> mapRequest(@NonNull ExceptionalFunction<Bytes, T> var1);

        @NonNull
        public ServerStreamingBuilder<T, R> method(@NonNull ServerStreamingMethod<T, R> var1);

        @NonNull
        public ServerStreamingBuilder<T, R> mapResponse(@NonNull ExceptionalFunction<R, Bytes> var1);

        @NonNull
        public ServerStreamingBuilder<T, R> respondTo(@NonNull Pipeline<? super Bytes> var1);

        @NonNull
        public Pipeline<? super Bytes> build();
    }

    public static interface ClientStreamingBuilder<T, R> {
        @NonNull
        public ClientStreamingBuilder<T, R> mapRequest(@NonNull ExceptionalFunction<Bytes, T> var1);

        @NonNull
        public ClientStreamingBuilder<T, R> method(@NonNull ClientStreamingMethod<T, R> var1);

        @NonNull
        public ClientStreamingBuilder<T, R> mapResponse(@NonNull ExceptionalFunction<R, Bytes> var1);

        @NonNull
        public ClientStreamingBuilder<T, R> respondTo(@NonNull Pipeline<? super Bytes> var1);

        @NonNull
        public Pipeline<? super Bytes> build();
    }

    public static interface BidiStreamingBuilder<T, R> {
        @NonNull
        public BidiStreamingBuilder<T, R> mapRequest(@NonNull ExceptionalFunction<Bytes, T> var1);

        @NonNull
        public BidiStreamingBuilder<T, R> method(@NonNull BidiStreamingMethod<T, R> var1);

        @NonNull
        public BidiStreamingBuilder<T, R> mapResponse(@NonNull ExceptionalFunction<R, Bytes> var1);

        @NonNull
        public BidiStreamingBuilder<T, R> respondTo(@NonNull Pipeline<? super Bytes> var1);

        @NonNull
        public Pipeline<? super Bytes> build();
    }

    public static interface UnaryBuilder<T, R> {
        @NonNull
        public UnaryBuilder<T, R> mapRequest(@NonNull ExceptionalFunction<Bytes, T> var1);

        @NonNull
        public UnaryBuilder<T, R> method(@NonNull ExceptionalFunction<T, R> var1);

        @NonNull
        public UnaryBuilder<T, R> mapResponse(@NonNull ExceptionalFunction<R, Bytes> var1);

        @NonNull
        public UnaryBuilder<T, R> respondTo(@NonNull Pipeline<? super Bytes> var1);

        @NonNull
        public Pipeline<? super Bytes> build();
    }
}

