/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.creator.impl.tipset;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.swirlds.common.metrics.RunningAverageMetric;
import com.swirlds.common.metrics.SpeedometerMetric;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashMap;
import java.util.Map;
import org.hiero.consensus.model.node.NodeId;

public class TipsetMetrics {
    private static final RunningAverageMetric.Config TIPSET_ADVANCEMENT_CONFIG = new RunningAverageMetric.Config("platform", "tipsetAdvancement").withDescription("The score, based on tipset advancement weight, of each new event created by this node. A score of 0.0 means the an event has zero advancement weight, while a score of 1.0 means that the event had the maximum possible advancement weight.");
    private final RunningAverageMetric tipsetAdvancementMetric;
    private static final RunningAverageMetric.Config SELFISHNESS_CONFIG = new RunningAverageMetric.Config("platform", "selfishness").withDescription("The score, based on tipset advancements, of how much this node is being selfish. Selfishness is defined as refusing to use another node's events as other parents.");
    private final RunningAverageMetric selfishnessMetric;
    private final Map<NodeId, SpeedometerMetric> tipsetParentMetrics = new HashMap<NodeId, SpeedometerMetric>();
    private final Map<NodeId, SpeedometerMetric> pityParentMetrics = new HashMap<NodeId, SpeedometerMetric>();

    public TipsetMetrics(@NonNull Metrics metrics, @NonNull Roster roster) {
        this.tipsetAdvancementMetric = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)TIPSET_ADVANCEMENT_CONFIG);
        this.selfishnessMetric = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)SELFISHNESS_CONFIG);
        for (RosterEntry address : roster.rosterEntries()) {
            NodeId nodeId = NodeId.of((long)address.nodeId());
            SpeedometerMetric.Config parentConfig = new SpeedometerMetric.Config("platform", "tipsetParent" + nodeId.id()).withDescription("Cycled when an event from that node is used as a parent because it optimized the tipset advancement weight.");
            SpeedometerMetric parentMetric = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)parentConfig);
            this.tipsetParentMetrics.put(nodeId, parentMetric);
            SpeedometerMetric.Config pityParentConfig = new SpeedometerMetric.Config("platform", "pityParent" + nodeId.id()).withDescription("Cycled when an event from that node is used as a parent without consideration of tipset advancement weight optimization (i.e. taking 'pity' on a node that isn't getting its events chosen as parents).");
            SpeedometerMetric pityParentMetric = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)pityParentConfig);
            this.pityParentMetrics.put(nodeId, pityParentMetric);
        }
    }

    @NonNull
    public RunningAverageMetric getTipsetAdvancementMetric() {
        return this.tipsetAdvancementMetric;
    }

    @NonNull
    public RunningAverageMetric getSelfishnessMetric() {
        return this.selfishnessMetric;
    }

    @NonNull
    public SpeedometerMetric getTipsetParentMetric(@NonNull NodeId nodeId) {
        return this.tipsetParentMetrics.get(nodeId);
    }

    @NonNull
    public SpeedometerMetric getPityParentMetric(@NonNull NodeId nodeId) {
        return this.pityParentMetrics.get(nodeId);
    }
}

