/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.cli;

import com.swirlds.cli.PlatformCli;
import com.swirlds.cli.utility.AbstractCommand;
import com.swirlds.cli.utility.SubcommandOf;
import com.swirlds.common.utility.CommonUtils;
import com.swirlds.platform.crypto.CryptoStatic;
import com.swirlds.platform.crypto.EnhancedKeyStoreLoader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStoreException;
import java.security.cert.CertificateEncodingException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterUtils;
import picocli.CommandLine;

@CommandLine.Command(name="generate-keys", mixinStandardHelpOptions=true, description={"Generates Node's X.509 certificate and private keys."})
@SubcommandOf(value=PlatformCli.class)
public class GenerateKeysCommand
extends AbstractCommand {
    private Path sigCertPath;
    @CommandLine.Parameters
    private List<Integer> ids;

    @CommandLine.Option(names={"-p", "--path"}, description={"Path to place the keys"})
    private void setSigCertPath(Path sigCertPath) {
        this.sigCertPath = this.pathMustExist(sigCertPath.toAbsolutePath());
    }

    public Integer call() throws KeyStoreException, ExecutionException, InterruptedException, IOException, CertificateEncodingException {
        Map<NodeId, KeysAndCerts> keysEntries = CryptoStatic.generateKeysAndCerts(this.ids.stream().map(NodeId::of).toList(), null);
        if (this.sigCertPath == null) {
            Files.createDirectories(Path.of(System.getProperty("user.dir"), new String[0]).resolve("data/keys"), new FileAttribute[0]);
            this.sigCertPath = Path.of(System.getProperty("user.dir"), new String[0]).resolve("data/keys");
        }
        for (Map.Entry<NodeId, KeysAndCerts> kEntry : keysEntries.entrySet()) {
            Path publicKeyStorePath = this.sigCertPath.resolve(String.format("s-public-%s.pem", RosterUtils.formatNodeName((NodeId)kEntry.getKey())));
            Path privateKeyStorePath = this.sigCertPath.resolve(String.format("s-private-%s.pem", RosterUtils.formatNodeName((NodeId)kEntry.getKey())));
            EnhancedKeyStoreLoader.writePemFile(true, privateKeyStorePath, kEntry.getValue().sigKeyPair().getPrivate().getEncoded());
            EnhancedKeyStoreLoader.writePemFile(false, publicKeyStorePath, kEntry.getValue().sigCert().getEncoded());
        }
        CommonUtils.tellUserConsole((String)("All " + this.ids.size() + " keys generated in:" + String.valueOf(this.sigCertPath)));
        return 0;
    }
}

