/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.cli;

import com.swirlds.cli.utility.AbstractCommand;
import com.swirlds.cli.utility.SubcommandOf;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.platform.cli.JrsTestReaderCommand;
import com.swirlds.platform.cli.utils.JtrUtils;
import com.swirlds.platform.testreader.JrsReportData;
import com.swirlds.platform.testreader.JrsTestIdentifier;
import com.swirlds.platform.testreader.JrsTestMetadata;
import com.swirlds.platform.testreader.JrsTestReader;
import com.swirlds.platform.testreader.JrsTestReportGenerator;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import picocli.CommandLine;

@CommandLine.Command(name="render", mixinStandardHelpOptions=true, description={"Render test data into an HTML report."})
@SubcommandOf(value=JrsTestReaderCommand.class)
public class JrsTestReaderRenderCommand
extends AbstractCommand {
    private Path testData;
    private String bucketPrefix;
    private String bucketPrefixReplacement;
    private Path metadataFile;
    private Path output = Path.of("report.html", new String[0]);

    private JrsTestReaderRenderCommand() {
    }

    @CommandLine.Parameters(description={"The csv file where test data can be found."}, index="0")
    private void setTestData(@NonNull Path testData) {
        this.testData = this.pathMustExist(testData);
    }

    @CommandLine.Parameters(description={"The bucket prefix to replace in order to convert bucket URLs to web links."}, index="1")
    private void setBucketPrefix(@NonNull String bucketPrefix) {
        this.bucketPrefix = bucketPrefix;
    }

    @CommandLine.Parameters(description={"The replacement for bucket prefix in order to convert bucket URLs to web links."}, index="2")
    private void setBucketPrefixReplacement(@NonNull String bucketPrefix) {
        this.bucketPrefixReplacement = bucketPrefix;
    }

    @CommandLine.Option(names={"-o", "--output"}, description={"Specify the path to the output html file. Defaults to 'report.html'."})
    private void setOutput(@NonNull Path output) {
        this.output = Objects.requireNonNull(FileUtils.getAbsolutePath((Path)output));
    }

    @CommandLine.Option(names={"-m", "--metadata"}, description={"Specify the path to the test metadata csv file."})
    private void setMetadataFile(@NonNull Path metadataFile) {
        this.metadataFile = FileUtils.getAbsolutePath((Path)metadataFile);
    }

    @NonNull
    public Integer call() {
        if (Files.exists(this.output, new LinkOption[0])) {
            try {
                Files.delete(this.output);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        JrsReportData data = JrsTestReader.loadTestResults(this.testData);
        Map<JrsTestIdentifier, JrsTestMetadata> metadata = JtrUtils.getTestMetadata(this.metadataFile);
        JrsTestReportGenerator.generateReport(data, metadata, Instant.now(), this.bucketPrefix, this.bucketPrefixReplacement, this.output);
        return 0;
    }
}

