/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.config.legacy;

import com.swirlds.base.utility.FileSystemUtils;
import com.swirlds.common.utility.CommonUtils;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.config.legacy.ConfigurationException;
import com.swirlds.platform.config.legacy.JarAppConfig;
import com.swirlds.platform.config.legacy.LegacyConfigProperties;
import com.swirlds.platform.system.address.AddressBookUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Scanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.roster.Address;
import org.hiero.consensus.model.roster.AddressBook;

@Deprecated(forRemoval=true)
public final class LegacyConfigPropertiesLoader {
    private static final String APP_PROPERTY_NAME = "app";
    private static final String ADDRESS_PROPERTY_NAME = "address";
    private static final String SWIRLD_PROPERTY_NAME = "swirld";
    public static final String ERROR_CONFIG_TXT_NOT_FOUND_BUT_EXISTS = "Config.txt file was not found but File#exists() claimed the file does exist";
    public static final String ERROR_MORE_THAN_ONE_APP = "config.txt had more than one line starting with 'app'. All but the last will be ignored.";
    public static final String ERROR_NO_PARAMETER = "%s needs a parameter";
    public static final String ERROR_ADDRESS_COULD_NOT_BE_PARSED = "'address' could not be parsed";
    public static final String ERROR_PROPERTY_NOT_KNOWN = "'%s' in config.txt isn't a recognized first parameter for a line";
    public static final String ERROR_NEXT_NODE_NOT_GREATER_THAN_HIGHEST_ADDRESS = "The next node ID must be greater than the highest node ID used for addresses";
    private static final Logger logger = LogManager.getLogger(LegacyConfigPropertiesLoader.class);

    private LegacyConfigPropertiesLoader() {
    }

    public static LegacyConfigProperties loadConfigFile(@NonNull Path configPath) throws ConfigurationException {
        Objects.requireNonNull(configPath, "configPath must not be null");
        if (!FileSystemUtils.waitForPathPresence((Path)configPath)) {
            throw new ConfigurationException("ERROR: Configuration file not found: %s".formatted(configPath.toString()));
        }
        LegacyConfigProperties configurationProperties = new LegacyConfigProperties();
        Scanner scanner = new Scanner(configPath, StandardCharsets.UTF_8);
        try {
            AddressBook addressBook = new AddressBook();
            long lineNumber = 0L;
            block22: while (scanner.hasNextLine()) {
                String line = LegacyConfigPropertiesLoader.readNextLine(scanner);
                ++lineNumber;
                if (line.isEmpty()) continue;
                String[] lineParameters = LegacyConfigPropertiesLoader.splitLine(line);
                int len = Math.max(10, lineParameters.length);
                String[] pars = new String[len];
                String[] parsOriginalCase = new String[len];
                for (int i = 0; i < len; ++i) {
                    parsOriginalCase[i] = i >= lineParameters.length ? "" : lineParameters[i].trim();
                    pars[i] = parsOriginalCase[i].toLowerCase(Locale.ENGLISH);
                }
                switch (pars[0]) {
                    case "swirld": {
                        LegacyConfigPropertiesLoader.setSwirldName(configurationProperties, lineParameters.length, parsOriginalCase[1]);
                        break;
                    }
                    case "app": {
                        if (configurationProperties.appConfig().isPresent()) {
                            LegacyConfigPropertiesLoader.onError(ERROR_MORE_THAN_ONE_APP);
                        }
                        String[] appParams = Arrays.copyOfRange(lineParameters, 2, lineParameters.length);
                        JarAppConfig appConfig = new JarAppConfig(lineParameters[1], appParams);
                        configurationProperties.setAppConfig(appConfig);
                        break;
                    }
                    case "address": {
                        try {
                            Address address = AddressBookUtils.parseAddressText(line);
                            if (address == null) continue block22;
                            addressBook.add(address);
                            break;
                        }
                        catch (ParseException ex) {
                            throw new ConfigurationException(String.format("%s [line: %d]: %s", ERROR_ADDRESS_COULD_NOT_BE_PARSED, lineNumber, line), ex);
                        }
                    }
                    case "nextnodeid": {
                        break;
                    }
                    default: {
                        LegacyConfigPropertiesLoader.onError(ERROR_PROPERTY_NOT_KNOWN.formatted(pars[0]));
                    }
                }
            }
            if (addressBook.getSize() > 0) {
                configurationProperties.setAddressBook(addressBook);
            }
            LegacyConfigProperties legacyConfigProperties = configurationProperties;
            scanner.close();
            return legacyConfigProperties;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException ex) {
                logger.error(LogMarker.EXCEPTION.getMarker(), ERROR_CONFIG_TXT_NOT_FOUND_BUT_EXISTS, (Throwable)ex);
                throw new IllegalStateException(ERROR_CONFIG_TXT_NOT_FOUND_BUT_EXISTS, ex);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }

    private static String readNextLine(Scanner scanner) {
        String line = scanner.nextLine();
        int pos = line.indexOf("#");
        if (pos > -1) {
            return line.substring(0, pos).trim();
        }
        return line.trim();
    }

    private static void handleParam(String propertyName, int paramLength, Runnable action) {
        if (paramLength >= 2) {
            action.run();
        } else {
            LegacyConfigPropertiesLoader.onError(ERROR_NO_PARAMETER.formatted(propertyName));
        }
    }

    private static void setSwirldName(LegacyConfigProperties configurationProperties, int paramLength, String value) {
        LegacyConfigPropertiesLoader.handleParam(SWIRLD_PROPERTY_NAME, paramLength, () -> configurationProperties.setSwirldName(value));
    }

    private static void onError(String message) {
        CommonUtils.tellUserConsolePopup((String)"Error", (String)message);
    }

    @NonNull
    private static String[] splitLine(@NonNull String line) {
        Objects.requireNonNull(line);
        String[] elms = line.split(",");
        for (int i = 0; i < elms.length; ++i) {
            elms[i] = elms[i].trim();
        }
        return elms;
    }
}

